/* generator.c: The opiegenerator() library function.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

        History:

	Modified by cmetz for OPIE 2.2. Use FUNCTION declaration et al.
              Bug fixes.
	Created at NRL for OPIE 2.2.
*/

/* DANGER:

   This function invites a user to enter his secret pass phrase. In a remote terminal
   session, this is *not* what you want!
*/

#include "opie_cfg.h"
#include "opie.h"

#include <string.h>

/* note return of -2 == secret fails passcheck */
int opiegenerator FUNCTION((buffer, secret, response), char *buffer AND char *secret AND char *response)
{
  int algorithm;
  int sequence;
  char *c;
  char key[8];

  if (!(buffer = strstr(buffer, "otp-")))
    return 1;

  buffer += 4;

  if (!(c = strchr(buffer, ' ')))
    return -1;

  *(c++) = 0;

  if (strcmp(buffer, "md5")) {
    if (strcmp(buffer, "md4"))
      return -1;
    else
      algorithm = 4;
  } else
    algorithm = 5;

  buffer = c;

  if (!(c = strchr(buffer, ' ')))
    return -1;

  *(c++) = 0;

  sequence = atoi(buffer);

  if ((sequence < 5) || (sequence > 10000))
    return -1;

  buffer = c;

  if (c = strchr(buffer, ' '))
    *c = 0;

  if (c = strchr(buffer, '\n'))
    *c = 0;

  if (opiepasscheck(secret))
    return -2;

  {
  int i;

  if (i = opiekeycrunch(algorithm, key, buffer, secret))
    return i;
  }

  while (sequence-- != 0)
    opiehash(key, algorithm);

  opiebtoe(response, key);

  return 0;
}
