/* opie.h: Data structures and values for the OPIE authentication
	system that a program might need.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

	Modified at NRL for OPIE 2.0.
	Written at Bellcore for the S/Key Version 1 software distribution
		(skey.h).
*/

#ifndef __ARGS

#if !defined(ANSIPROTO) && (defined(__TURBOC__) || defined(__STDC__) || defined(LATTICE))
#define ANSIPROTO       1
#endif

#ifndef __ARGS
#ifdef  ANSIPROTO
#define __ARGS(x)       x
#else
#define __ARGS(x)       ()
#endif
#endif

#endif	/* __ARGS */

/* Server library's internal state block.
   Code outside libopie.a should treat this as an opaque data block and
   should not ever manipulate this structure in any way. Its format is
   subject to change in future versions of OPIE.
*/
struct opie {
  FILE *keyfile;
  char buf[256];
  char *logname;
  int n;
  char *seed;
  char *val;
  long recstart;	/* needed so reread of buffer is efficient */
};

void opiehash __ARGS((char *x, unsigned algorithm));
int keycrunch __ARGS((unsigned algorithm, char *result, char *seed, char *passwd));
char *btoe __ARGS((char *engout, char *c));
char *put8 __ARGS((char *out, char *s));
int etob __ARGS((char *out, char *e));
void strip_crlf __ARGS((char *buf));
int opiechallenge __ARGS((struct opie * mp, char *name, char *ss));
int opielookup __ARGS((struct opie * mp, char *name));
int opieverify __ARGS((struct opie * mp, char *response));
char *readpass __ARGS((char *buf, int n));
int opieaccessfile __ARGS((char *));
int opiealways __ARGS((char *));
void opieversion __ARGS((void));
int opieinsecure __ARGS((void));
int opiekeycrunch __ARGS((unsigned, char *, char *, char *));
char *opiereadpass __ARGS((char *, int));
int opiepasscheck __ARGS((char *));
char *opiebtoe __ARGS((char *, char *));
int opieetob __ARGS((char *, char *));
void opiesevenbit __ARGS((char *));
int opiegetsequence __ARGS((struct opie *));
void opiestrip_crlf __ARGS((char *));
int opiebtoa8 __ARGS((char *, char *));
int opieatob8 __ARGS((char *, char *));
void opiebackspace __ARGS((char *));

/* Minimum length of a secret password */
#ifndef OPIE_PASS_MIN
#define OPIE_PASS_MIN 10
#endif	/* OPIE_PASS_MIN */

/* Maximum length of a secret password */
#ifndef OPIE_PASS_MAX
#define OPIE_PASS_MAX 127
#endif	/* OPIE_PASS_MAX */

/* Minimum length of a seed */
#ifndef OPIE_SEED_MIN
#define OPIE_SEED_MIN 5
#endif	/* OPIE_SEED_MIN */

/* Maximum length of a seed */
#ifndef OPIE_SEED_MAX
#define OPIE_SEED_MAX 32
#endif	/* OPIE_SEED_MAX */

/* Maximum length of a challenge (otp-md? 9999 seed) */
#ifndef OPIE_CHALLENGE_MAX
#define OPIE_CHALLENGE_MAX (7+1+4+1+OPIE_SEED_MAX)
#endif	/* OPIE_CHALLENGE_MAX */

/* Maximum length of a response (six words up to four chars each w/spaces) */
#ifndef OPIE_RESPONSE_MAX
#define OPIE_RESPONSE_MAX (6*4+5)
#endif	/* OPIE_RESPONSE_MAX */

/* Maximum length of a principal (read: user name) */
#ifndef OPIE_PRINCIPAL_MAX
#define OPIE_PRINCIPAL_MAX 32
#endif	/* OPIE_PRINCIPAL_MAX */

/* How many characters from the host name to use in the seed? */
#define NAMELEN 2

/* This buffer should be only NAMELEN+1 chars long. However, we found
   that 4.4BSD croaks with ENOMEM if the buffer passwd is shorter than
   the current hostname, a quite different behavior than <= 4.3, which
   worked like a strncpy. The BSD man page for gethostname() is just
   vague enough that this isn't a bug. */
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 32
#endif	/* MAXHOSTNAMELEN */
