/*
 * @(#) posignal.c  RCS: $Revision: 1.4 $ $Date: 95/03/02 12:54:07 $
 */
#if !defined(_POSIX_SOURCE)
#define _POSIX_SOURCE
#endif
#include <signal.h>
#include "posignal.h"

/*
 * Signal with posix signal semantics
 *
 * Beware! If sysconf(_SC_JOB_CONTROL) != 0, sa_flags must be SA_NOCLDSTOP if 
 * you don't want SIGSTOP to the child to cause SIGCHLD to the caller of this 
 * routine.  Note that SIGCHLD may not exist if sysconf() returned zero.
 * Note also that POSIX SIGCHLD is NOT the same as System V.3 SIGCLD.
 */
#if defined(__STDC__) || defined(__cplusplus)
pfv posignal(int sig, pfv handler)
#else
pfv posignal(sig, handler) int sig; pfv handler;
#endif
{
   struct sigaction sact, oact;
   int res;

   sact.sa_handler = handler;	/* some compilers break here; see psignal.h */
   sact.sa_flags   = SA_NOCLDSTOP;
   sigemptyset(&sact.sa_mask);
   res = sigaction(sig, &sact, &oact);
   if (res < 0) {
      return SIG_ERR;
   }
   return oact.sa_handler;
}
