/* pkcrack - zipdecrypt.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: zipdecrypt.c,v 1.3 1996/06/12 09:47:30 conrad Release $
 *
 * $Log: zipdecrypt.c,v $
 * Revision 1.3  1996/06/12 09:47:30  conrad
 * Release version
 *
 * Revision 1.2  1996/06/11 20:09:00  conrad
 * improved version. Now handles the central directory correctly
 * (hopefully).
 *
 * Revision 1.1  1996/06/11 10:24:29  conrad
 * Initial revision
 *
 */

static char RCSID[]="$Id: zipdecrypt.c,v 1.3 1996/06/12 09:47:30 conrad Release $";

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "crc.h"
#include "mktemptbl.h"
#include "pkcrack.h"
#include "keystuff.h"

#ifndef O_BINARY
#define	O_BINARY	0
#endif

#define	MIN(a,b)	(((a)<(b))?(a):(b))

#define	NUMOFFSETS	100

static uword	offset=0, dirOffset;

static struct file {
    char	name[13];
    uword	relOffset;
} offsets[NUMOFFSETS];

static int	numOffsets=0;
static byte	buffer[1024];

static int copy( int outf, int inf, int len, int decrypt )
{
int	i, j, finished=0;
byte	p;

    len += 12*decrypt;

    i = read( inf, buffer, MIN(1024,len) );
    if( i < MIN(1024,len) )
    {
	fprintf( stderr, "File too short. Aborting...\n" );
	finished = 1;
    }

    j = 0;
    if( decrypt )
	for( ; j < 12; j++ )
	    p = cUpdateKeys( buffer[j] );

    while( len > 0 )
    {
	if( decrypt )
	    for( i = 0; i+j < MIN(1024,len); i++ )
		buffer[i+j] = cUpdateKeys( buffer[i+j] );
	write( outf, &buffer[j], MIN(1024,len)-j );
	offset += MIN(1024,len)-j;
	len -= MIN(1024,len);
	if( len > 0 )
	{
	    i = read( inf, buffer, MIN(1024,len) );
	    if( i < MIN(1024,len) )
	    {
		fprintf( stderr, "File too short. Aborting...\n" );
		finished = 1;
	    }
	    j = 0;
	}
    }

    return finished;
}

void main( int argc, char **argv )
{
int	i, n=0, infile, outfile, finished=0, decrypt=0;
byte	c, p;
uword	compsize, fnlength, extralength, commentlength;

    if( argc != 6 )
    {
	fprintf( stderr, "Usage: %s <key0> <key1> <key2> <ciphertextfilename> <plaintextfilename>\n", argv[0] );
	return;
    }

    infile = open( argv[4], O_RDONLY | O_BINARY );
    if( infile == -1 )
    {
	fprintf( stderr, "Ciphertextfile %s not found!\n", argv[4] );
	return;
    }
    outfile = open( argv[5], O_CREAT | O_WRONLY | O_BINARY, 0644 );
    if( outfile == -1 )
    {
	fprintf( stderr, "Couldn't open plaintextfile %s!\n", argv[5] );
	return;
    }

    mkCrcTab();

    do{
	i = read( infile, buffer, 4 );
	buffer[4] = 0;
	if( i < 4 )
	{
	    fprintf( stderr, "File too short. Aborting.\n" );
	    finished = 1;
	}
	else if( strcmp( buffer, "PK\003\004" ) )
	{
	    if( !strcmp( buffer, "PK\001\002" ) )
	    {
		dirOffset = offset;
		while( !strcmp( buffer, "PK\001\002" ) && !finished )
		{
		    write( outfile, buffer, 4 );
		    offset += 4;
		    i = read( infile, buffer, 42 );
		    if( i < 42 )
		    {
			fprintf( stderr, "Structure of ZIP-file corrupt. Aborting.\n" );
			finished = 1;
		    }
		    if( !finished )
		    {
			compsize = (((int)buffer[16])) +
				   (((int)buffer[17])<<8) +
				   (((int)buffer[18])<<16) +
				   (((int)buffer[19])<<24);
			fnlength = (((int)buffer[24])) +
				   (((int)buffer[25])<<8);
			extralength =	(((int)buffer[26])) +
					(((int)buffer[27])<<8);
			commentlength =	(((int)buffer[28])) +
					(((int)buffer[29])<<8);
			if( (buffer[4]&1) )
			{
			    buffer[4] &= 0xfe;
			    compsize -= 12;
			    buffer[16] = compsize&0xff;
			    buffer[17] = (compsize>>8)&0xff;
			    buffer[18] = (compsize>>16)&0xff;
			    buffer[19] = (compsize>>24)&0xff;
			}
			i = read( infile, &buffer[42], fnlength );
			buffer[42+fnlength] = 0;
			if( i < fnlength )
			{
			    fprintf( stderr, "Structure of ZIP-file corrupt. Aborting.\n" );
			    finished = 1;
			}
		    }
		    if( !finished )
		    {
			for( i = 0; i < numOffsets && strcmp( offsets[i].name, &buffer[42] ); i++ );
			if( i >= numOffsets )
			{
			    fprintf( stderr, "Central directory contains unknown filename: %s\n", &buffer[42] );
			    finished = 1;
			}
		    }
		    if( !finished )
		    {
			buffer[38] = offsets[i].relOffset&0xff;
			buffer[39] = (offsets[i].relOffset>>8)&0xff;
			buffer[40] = (offsets[i].relOffset>>16)&0xff;
			buffer[41] = (offsets[i].relOffset>>24)&0xff;
			write( outfile, buffer, 42+fnlength );
			offset += 42+fnlength;
			finished = copy( outfile, infile, extralength+commentlength, 0 );
		    }
		    if( !finished )
		    {
			i = read( infile, buffer, 4 );
			if( i < 4 )
			{
			    fprintf( stderr, "File endet prematurely.\n" );
			    finished = 1;
			}
			buffer[4] = 0;
		    }
		}
		if( !finished && !strcmp( buffer, "PK\005\006" ) )
		{
		    write( outfile, buffer, 4 );
		    offset += 4;
		    i = read( infile, buffer, 18 );
		    if( i < 18 )
		    {
			fprintf( stderr, "End of central directory record corrupt.\n" );
			finished = 1;
		    }
		    if( !finished )
		    {
			buffer[12] = dirOffset&0xff;
			buffer[13] = (dirOffset>>8)&0xff;
			buffer[14] = (dirOffset>>16)&0xff;
			buffer[15] = (dirOffset>>24)&0xff;
			write( outfile, buffer, 18 );
			offset += 18;
			copy( outfile, infile, ((int)buffer[16])+(((int)buffer[17])<<8), 0 );
			finished = 1; /* success */
		    }
		}
		
	    }
	    else
	    {
		fprintf( stderr, "Structure of ZIP-file corrupt. Aborting.\n" );
		finished = 1;
	    }
	}
	if( !finished )
	{
	    offsets[numOffsets].relOffset = offset;
	    write( outfile, buffer, 4 );
	    offset += 4;
	    i = read( infile, buffer, 26 );
	    if( i != 26 )
	    {
		fprintf( stderr, "File too short. Aborting.\n" );
		finished = 1;
	    }
	}
	if( !finished )
	{
	    compsize =	(((int)buffer[14])) +
			(((int)buffer[15])<<8) +
			(((int)buffer[16])<<16) +
			(((int)buffer[17])<<24);
	    if( (buffer[2]&1) )
	    {
		buffer[2] &= 0xfe;
		decrypt = 1;
		compsize -= 12;
		buffer[14] = compsize&0xff;
		buffer[15] = (compsize>>8)&0xff;
		buffer[16] = (compsize>>16)&0xff;
		buffer[17] = (compsize>>24)&0xff;
		sscanf( argv[1], "%x", &key0 );
		sscanf( argv[2], "%x", &key1 );
		sscanf( argv[3], "%x", &key2 );
	    }
	    fnlength =	(((int)buffer[22])) +
			(((int)buffer[23])<<8);
	    extralength = (((int)buffer[24])) +
			  (((int)buffer[25])<<8);
	    write( outfile, buffer, 26 );
	    offset += 26;
	    finished = copy( outfile, infile, fnlength+extralength, 0 );
	    strncpy( offsets[numOffsets].name, buffer, MIN(fnlength,12) );
	    offsets[numOffsets++].name[MIN(12,fnlength)] = 0;
	    if( !finished )
		finished = copy( outfile, infile, compsize, decrypt );
	    decrypt = 0;
	}
    }while( !finished );

    close( infile );
    close( outfile );
}

