/* pkcrack - main.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: main.c,v 1.2 1996/06/12 09:47:13 conrad Release $
 *
 * $Log: main.c,v $
 * Revision 1.2  1996/06/12 09:47:13  conrad
 * Release version
 *
 * Revision 1.1  1996/06/10 17:50:20  conrad
 * Initial revision
 *
 */

static char RCSID[]="$Id: main.c,v 1.2 1996/06/12 09:47:13 conrad Release $";

#include <time.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "crc.h"
#include "mktemptbl.h"
#include "stage1.h"
#include "pkcrack.h"
#include "stage2.h"
#include "stage3.h"

#ifndef O_BINARY
#define	O_BINARY	0
#endif

byte	plaintext[MAXFILELEN], ciphertext[MAXFILELEN];
uword	key2i[KEY2SPACE];
int	numKey2s=0;

void main( int argc, char **argv )
{
int		crypt, plain, cryptlength, plainlength;
struct stat	filestat;
time_t		now;
int		i;

    if( argc != 3 )
    {
	fprintf( stderr, "Usage: %s <crypted_file> <plaintext_file>\n", argv[0] );
	return;
    }

    crypt = open( argv[1], O_RDONLY | O_BINARY );
    if( crypt == -1 )
    {
	fprintf( stderr, "Cryptfile %s not found!\n", argv[1] );
	return;
    }
    plain = open( argv[2], O_RDONLY | O_BINARY );
    if( plain == -1 )
    {
	fprintf( stderr, "Plaintextfile %s not found!\n", argv[2] );
	return;
    }

    fstat( plain, &filestat );
    plainlength = filestat.st_size;
    fstat( crypt, &filestat );
    cryptlength = filestat.st_size;
    if( plainlength > cryptlength-12 )
    {
	fprintf( stderr, "Warning! Plaintext is longer than Ciphertext!\n" );
    }
    if( plainlength < 13 )
    {
	fprintf( stderr, "Plaintext must be at least 13 bytes! Aborting.\n" );
	return;
    }
    if( plainlength > MAXFILELEN-12 )
    {
	fprintf( stderr, "Using only %d bytes of plaintext...\n", MAXFILELEN-12 );
	plainlength = MAXFILELEN-12;
	cryptlength = MAXFILELEN;
    }
    cryptlength = plainlength + 12;

    if( read( crypt, ciphertext, cryptlength ) !=  cryptlength )
    {
	fprintf( stderr, "Couldn't read ciphertext!\n" );
	return;
    }
    if( read( plain, &plaintext[12], plainlength ) != plainlength )
    {
	fprintf( stderr, "Couldn't read plaintext!\n" );
	return;
    }
    close( plain );
    close( crypt );

    now = time(NULL);
    fprintf( stderr, "Files read. Starting stage 1 on %s", ctime(&now) );

    preCompTemp();
    mkCrcTab();

    generate1stSetOfKey2s( cryptlength-1 );
    for( i = cryptlength-1; i >= 25 && numKey2s > 0; i-- )
	reduceKey2s( i );

/*    if( numKey2s < 10000 )
    {*/
	printf( "Done. Left with %d possible Values.\n", numKey2s );
/*	for( i = 0; i < numKey2s; i++ )
	    printf( "%8x\n", key2i[i] );*/
    /*}*/
    fflush( stdout );

    now = time(NULL);
    fprintf( stderr, "Stage 1 completed. Starting stage 2 on %s", ctime(&now) );

    initMulTab();
    for( i = 0; i < numKey2s; i++ )
    {
	buildKey2Lists( key2i[i] );
	/*fprintf( stderr, "%d\r", i );
	fflush( stderr );*/
    }

    now = time(NULL);

/* Stage 3 is now called by stage 2.
    fprintf( stderr, "Stage 2 completed. Starting stage 3 on %s", ctime(&now) );

    initStage3Tab();
    findPwd( loesung0, loesung1, loesung2 );

    now = time(NULL);*/

    fprintf( stderr, "Finished on %s", ctime(&now) );

}

