/* pkcrack - decrypt.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: decrypt.c,v 1.1 1996/06/10 17:37:23 conrad Exp $
 *
 * $Log: decrypt.c,v $
 * Revision 1.1  1996/06/10 17:37:23  conrad
 * Initial revision
 *
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "crc.h"
#include "mktemptbl.h"
#include "stage1.h"
#include "pkcrack.h"
#include "keystuff.h"

#ifndef O_BINARY
#define	O_BINARY	0
#endif

void main( int argc, char **argv )
{
int	i, n=0, infile, outfile;
byte	c, p;

    if( argc != 4 )
    {
	fprintf( stderr, "Usage: %s <password> <ciphertextfilename> <plaintextfilename>\n", argv[0] );
	fprintf( stderr, "Reads ciphertext from stdin, prints plaintext on stdout.\n" );
	return;
    }

    infile = open( argv[2], O_RDONLY | O_BINARY );
    if( infile == -1 )
    {
	fprintf( stderr, "Ciphertextfile %s not found!\n", argv[2] );
	return;
    }
    outfile = open( argv[3], O_CREAT | O_WRONLY | O_BINARY, 0644 );
    if( outfile == -1 )
    {
	fprintf( stderr, "Couldn't open plaintextfile %s!\n", argv[3] );
	return;
    }

    mkCrcTab();

    initkeys( );
    for( i = 0; i < strlen(argv[1]); i++ )
    {
	updateKeys( argv[1][i] );
	/*printf( "%8x %8x %8x\n", key0, key1, key2 );*/
    }

    while( i > 0 )
    {
	/*printf( "key0=%8x, key1=%8x, key2=%8x\n", key0, key1, key2 );*/
	i = read( infile, &c, 1 );
	if( i == 1 )
	{
	    p = c^key3;
	    write( outfile, &p, 1 );
	    /*if( n < 40000 )
	    	printf( "%5d %3d %3d %8x\n", n++, c, p, key2 );*/
	    updateKeys( p );
	}
    }

    close( infile );
    close( outfile );
}

