/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

/*********************************************************
 *
 *      Time Routines provided by the OS
 *
 *	Copyright 1986  University of British Columbia
 *
 *	See util/time.d for more info
 *
 *      30 May 1986	Created by bbh
 *      25 Jul 1989     T-Zone for daylight saving time, incr time instead
 *                      of zone, rdn
 *
 *********************************************************
 */
#ifdef MAC
#include <time.h>
#include <stdlib.h>
#include "Mac.h"
#include "aux_time.h"
#include "secure.h"
#else
#include "secure.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/timeb.h>

#ifdef SINIX
#define timelocal(tmptr) mktime(tmptr)
#endif

/* Some systems have time.h, others have sys/time.h, others have both, but different.
 * The following construction assumes that a system prevents multiple inclusions
 * of the same .h file through appropriate means. If this is not the case, it might be
 * possible that you have to remove one of the two following includes:
 */

#include <time.h> 
#include <sys/time.h>

#include "aux_time.h"
#endif

extern ftime();
extern struct tm *	gmtime();
extern struct tm *	localtime();
Boolean aux_localtime = FALSE;


#define TIMELEN 40

#ifndef MAC
static t_int
t_now( ptr_ti, ptr_tz )
t_int*		ptr_ti;
t_delta*		ptr_tz;
{
	struct timeb  ft;
	struct tm   * lt;

	ftime( &ft );

	lt = localtime( &ft.time );

	if ( ptr_ti ) *ptr_ti = ft.time + (lt->tm_isdst ? T_1HOUR : 0);
	if ( ptr_tz ) *ptr_tz = -ft.timezone * T_1MIN;

	return( ft.time );
}
#else
static t_int t_now(t_int *ptr_ti, t_delta *ptr_tz)
/* Liefert die Zeit in Sekunden seit 01.01.1904 (Mac-Kalenderzeit), in GMT.
   Das Ergebnis wird auch in *ptr_ti zurueckgeliefert, *ptr_tz enthaelt die
   Zeitverschiebung der lokalen Zeit in Minuten westwaerts zu GMT 
   (bei MEST also 120) */
   
   {
   time_t localtimer, gmtimer;
   struct tm *tmlocal;
   int timezone;
   
   /* Sekunden seit 01.01.1904 */
   time(&localtimer);
   
   /* lokale Zeit */
   tmlocal = localtime(&localtimer);
   
   /* Zeitzone in Sekunden */
   timezone = MacGetEnvInt("TIMEZONE") * T_1MIN;
   
   /* GMT-timer */
   gmtimer = localtimer + tmlocal->tm_isdst * T_1HOUR - timezone;
   
   if (ptr_ti)
      *ptr_ti = gmtimer;
      
   if (ptr_tz)
      *ptr_tz = timezone - tmlocal->tm_isdst * T_1HOUR;
         
   return (gmtimer);
   } /* t_now */

#endif /* MAC */


static T_REC*
t_itor( tr, ti, tz )
T_REC*		tr;
t_int		ti;
t_delta		tz;
{
	struct tm *		lt;

	if(aux_localtime == TRUE) ti += tz;

#if !defined(MAC) && !defined(__HP__)
    lt = gmtime( &ti );
#else
    lt = localtime((time_t *) &ti );
#endif /* MAC __HP__ */

	tr->sec	 = lt->tm_sec;
	tr->minu = lt->tm_min;
	tr->hour = lt->tm_hour;
	tr->day	 = lt->tm_mday - 1;
	tr->mon	 = lt->tm_mon;
	tr->year = lt->tm_year + 1900;
	if(aux_localtime == TRUE) tr->zone = tz / T_1MIN;
        else tr->zone = 0;

	return( tr );
}

static struct tm *
t_rtotm(tr)
T_REC*		tr;
{
	static struct tm lt;

	lt.tm_sec = tr->sec;
	lt.tm_min = tr->minu;
	lt.tm_hour = tr->hour;
	lt.tm_mday = tr->day + 1;
	lt.tm_mon = tr->mon;
	lt.tm_year = tr->year - 1900;
#if !defined(APOLLO) && !defined(__HP__) && !defined(SINIX)
	lt.tm_gmtoff = (long)(tr->zone * T_1MIN);
#endif

	return(&lt);
}

static T_REC *
t_tmtor(lt)
struct tm *lt;
{
	static T_REC tr;

	tr.sec	 = lt->tm_sec;
	tr.minu = lt->tm_min;
	tr.hour = lt->tm_hour;
	tr.day	 = lt->tm_mday - 1;
	tr.mon	 = lt->tm_mon;
	tr.year = lt->tm_year + 1900;
#if !defined(APOLLO) && !defined(__HP__) && !defined(SINIX)
	tr.zone = lt->tm_gmtoff / T_1MIN;
#endif

	return(&tr);
}

#ifndef MAC
static t_int
t_rtoi( ptr_ti, ptr_tz, tr )
t_int*		ptr_ti;
t_delta*		ptr_tz;
T_REC*		tr;
{
	t_int		ti;
	t_delta		tz;

	tz = tr->zone * T_1MIN;

	ti = ( (tr->year - 1970) * 365 + (tr->year - 1972 + 3) / 4
	     + t_doy(tr->day, tr->mon, tr->year) )
	*T_1DAY
	     + tr->hour * T_1HOUR
	     + tr->minu * T_1MIN
	     + tr->sec  * T_1SEC
	    -tz;

	if ( ptr_ti ) *ptr_ti = ti;
	if ( ptr_tz ) *ptr_tz = tz;
	return( ti );
}
#else
static t_int t_rtoi(t_int *ptr_ti, t_delta *ptr_tz, T_REC *tr)
/* In tr lokale Zeit, zurueck in *ptr_ti GMT-Zeit in Sekunden,
   in *ptr_tz Zeitverschiebung in Sekunden */
   
   {
   struct tm date;
   time_t ti;
   time_t tz;
   
   tz = tr->zone * T_1MIN;
   
   date.tm_year = tr->year-1900;
   date.tm_mon = tr->mon;
   date.tm_mday = tr->day+1;
   date.tm_hour = tr->hour;
   date.tm_min = tr->minu;
   date.tm_sec = tr->sec;
   date.tm_isdst = 0;
   
   ti = mktime(&date) - tz;
   
   if (ptr_ti) *ptr_ti = ti;
   if (ptr_tz) *ptr_tz = tz;
   
   return( ti );

   } /* t_rtoi */
#endif /* MAC */


static int	
t_rvalid( tr )
T_REC*		tr;
{
	return( tr             && 
	    tr->sec >= 0     && tr->sec < 60        && 
	    tr->minu >= 0     && tr->minu < 60	 && 
	    tr->hour >= 0    && tr->hour < 24	 && 
	    tr->day >= 0     && tr->day < t_dpm(tr->mon, tr->year) && 
	    tr->mon >= 0     && tr->mon < 12	 && 
	    tr->year >= 1972 && tr->year < 2099	 && 
	    tr->zone >= -720 && tr->zone <= 720 );
}


static int	dpm_tbl[] = 
{ 
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };


static int	doy_tbl[] = 
{  
	0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334 };



static int	
t_isleap( year )
int	year;
{
	return( year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) );
}


static int	
t_dpm( mon, year )
int	mon;
int	year;
{
	if ( mon == 1 && t_isleap(year) )
		return( 29 );

	return( dpm_tbl[mon] );
}


static int	
t_doy( day, mon, year )
int	day;
int	mon;
int	year;
{
	if ( mon > 1 && t_isleap(year) )
		return( doy_tbl[mon] + 1 + day );

	return( doy_tbl[mon] + day );
}


static T_REC*
t_rnow( tr )
T_REC*		tr;
{
	t_int		ti;
	t_delta		tz;

	t_now( &ti, &tz );

	return( t_itor(tr, ti, tz) );
}



static char	*
t_rtox( tx, tr )
char*	tx;
T_REC*		tr;
{
	char * 	zone_fmt;
	int	zone;

	sprintf(tx, "%02d%02d%02d%02d%02d%02d",
	    tr->year - 1900,
	    tr->mon + 1,
	    tr->day + 1,
	    tr->hour,
	    tr->minu,
	    tr->sec );

	if ( (zone = tr->zone) == 0 ) zone_fmt = "Z";

	else if ( zone > 0 ) zone_fmt = "+%02d%02d";

	else zone_fmt = "-%02d%02d", zone = -zone;

	sprintf(tx + 12, zone_fmt, zone / 60, zone % 60 );

	return( tx );
}


static T_REC * t_xtor( tr, tx )
T_REC*		tr;
char*	tx;
{
	char	c;
	int	zh;
	int	zm;

	if ( sscanf(tx, "%02d%02d%02d%02d%02d",
	    &tr->year,
	    &tr->mon ,
	    &tr->day ,
	    &tr->hour,
	    &tr->minu ) != 5 )
		return ( (T_REC * ) 0);
	tx += 10;

	if ( (*tx == '+') || (*tx == '-') ) tr->sec = 0;
	else {
		if ( sscanf(tx, "%02d", &tr->sec) < 1 ) tr->sec = 0;
		else tx += 2;
	}

	c = *tx++;
	if ( c == 'Z' ) tr->zone = 0;
	else if ( c == '+' || c == '-' ) {
		if ( sscanf(tx, "%02d%02d", &zh, &zm) < 2 ) 
			return ( (T_REC * ) 0);
		tx += 4;

		tr->zone = zh * 60 + zm;

		if ( c == '-' ) tr->zone = -tr->zone;
	} 
	else return ( (T_REC * ) 0);

	if ( *tx ) 
		return ( (T_REC * ) 0);

	tr->day  -= 1;
	tr->mon  -= 1;
	tr->year += 1900;

	return( t_rvalid(tr) ? tr : (T_REC * ) 0 );
}


UTCTime * aux_current_UTCTime()
{

	T_REC     now;
	char	* ts;
	char	* proc = "aux_current_UTCTime";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	ts = (char * ) malloc(TX_MAXLEN + 1);
	if ( !ts )   {
		aux_add_error(EMALLOC, "ts", CNULL, 0, proc);
		return (CNULL);
	}
	t_rnow(&now);
	return t_rtox(ts, &now);
}


char * aux_readable_UTCTime(tx)
UTCTime	*tx;
{
	T_REC         tr;
        struct tm   * tm;
        time_t        gmt;
	char	    * text;
	struct timeb  ft;
	char	    * proc = "aux_readable_UTCTime";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!(text = (char * ) malloc(64)))  {
		aux_add_error(EMALLOC, "ts", CNULL, 0, proc);
		return (CNULL);
	}
	if (tx && t_xtor(&tr, tx)) {

                tm = t_rtotm(&tr);
                gmt = timelocal(tm);
		ftime( &ft );   /* little detour to get the time zone */
		gmt += -ft.timezone * T_1MIN;
                tm = localtime(&gmt);
                sprintf(text, "%s", asctime(tm));
		text[strlen(text) - 1] = '\0';  /* eliminate trailing \n */

		return(text);

	} 
	else return (CNULL);
}


UTCTime * aux_delta_UTCTime(time)
UTCTime	* time;
{
	T_REC     dr;
	char	* ts;
	int	  ti, tz;
	char	* proc = "aux_delta_UTCTime";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!t_rvalid(t_xtor(&dr, time)))   
		return (CNULL);

	ts = (char * ) malloc(TX_MAXLEN + 1);
	if ( !ts )   {
		aux_add_error(EMALLOC, "ts", CNULL, 0, proc);
		return (CNULL);
	}


	t_rtoi(&ti, &tz, &dr);

	ti += T_1YEAR;
	t_itor(&dr, ti, tz);

	return t_rtox(ts, &dr);
}


int
aux_interval_UTCTime(time, notbefore, notafter)
UTCTime	*time;
UTCTime	*notbefore;
UTCTime	*notafter;
{
	T_REC   rt;
	t_int   izone;
	Boolean freeflag = FALSE;
	unsigned int	ibefore, iafter, inow;

	if (!time) {
		time = aux_current_UTCTime();
		freeflag = TRUE;
	}

	if (!t_rvalid(t_xtor(&rt, time))) return - 1;
	t_rtoi(&inow, &izone, &rt);

	if (!t_rvalid(t_xtor(&rt, notbefore))) return - 1;
	t_rtoi(&ibefore, &izone, &rt);

	if (!t_rvalid(t_xtor(&rt, notafter))) return - 1;
	t_rtoi(&iafter, &izone, &rt);

	if(freeflag) free(time);

	if(inow < ibefore) return(1);
	if(inow > iafter) return(2);
	return(0);
}


int
aux_cmp_UTCTime(time1, time2)
UTCTime	*time1;
UTCTime	*time2;
{
	T_REC   rt;
	t_int   izone;
	Boolean freeflag = FALSE;
	unsigned int inext, inow;

	if (!time1) {
		time1 = aux_current_UTCTime();
		freeflag = TRUE;
	}

	if (!t_rvalid(t_xtor(&rt, time1))) return - 1;
	t_rtoi(&inow, &izone, &rt);

	if (!t_rvalid(t_xtor(&rt, time2))) return - 1;
	t_rtoi(&inext, &izone, &rt); 

	if(freeflag) free(time1);

	if(inow > inext) return(1);
	if(inow < inext) return(2);
        return(0);
}



UTCTime *
delta_time_rec(time, delta)
UTCTime	*time;
T_REC	*delta;
{
	T_REC     dr, *tr;
	char	* ts;
	int	  ti, tz;
        struct tm   * tm;
        time_t        gmt;
	struct timeb  ft;
	char	* proc = "delta_time_rec";


	if(time) if (!t_rvalid(t_xtor(&dr, time))) 
		return (CNULL);

	ts = (char *) malloc(TX_MAXLEN + 1);
	if ( !ts )   {
		aux_add_error(EMALLOC, "ts", CNULL, 0, proc);
		return (CNULL);
	}

	if(time) {
                t_rtoi(&ti, &tz, &dr);
		ti += ( delta->year * T_1YEAR + delta->mon * T_1MONTH + delta->day * T_1DAY + delta->hour * T_1HOUR + delta->minu * T_1MIN + delta->sec * T_1SEC );
		t_itor(&dr, ti, tz);
		return(t_rtox(ts, &dr));
	}
	else {
                tm = t_rtotm(delta);
                gmt = timelocal(tm);
		ftime(&ft);   /* little detour to get the time zone */
		gmt += ft.timezone * T_1MIN;
                tm = localtime(&gmt);
		tr = t_tmtor(tm);
		tr->zone = 0;
 		return(t_rtox(ts, tr));
	}
}

UTCTime *get_nextUpdate(lastUpdate)
UTCTime *lastUpdate;
{
	T_REC   * delta_rec;
	char    * timetype;
	char    * time, *readable_time;
	UTCTime * nextUpdate;
	char    * proc = "get_nextUpdate";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!lastUpdate) {
		aux_add_error(EINVALID, "lastUpdate missing", CNULL, 0, proc);
		return (CNULL);
	}

nextupdate:
	fprintf(stderr, "\nSpecify the next scheduled date of issue for your revocation list:\n");
	fprintf(stderr, "Date of issue: \n");
	fprintf(stderr, "   ABSOLUTE or\n");
        readable_time = aux_readable_UTCTime(lastUpdate);
	fprintf(stderr, "   RELATIVE to %s ?\n", readable_time);
	if(readable_time) free(readable_time);
	fprintf(stderr, "(A/R) (CR for R):  "); 
	timetype = gets((char *)malloc(2));
	if(strlen(timetype) == 0) {
		free(timetype);
		timetype = "R";
	}
	if ((*timetype != 'A') && (*timetype != 'R')) {
		fprintf(stderr, "Type must me either 'A' or 'R'\n");
		free(timetype);
		goto nextupdate;
	}
	if (*timetype == 'R') {
		if ( !(delta_rec = (T_REC *)malloc(sizeof(T_REC))) ) {
			aux_add_error(EMALLOC, "delta_rec", CNULL, 0, proc);
			return (CNULL);
		}
		fprintf(stderr, "\nThe revocation list should be valid (from %s)\n", aux_readable_UTCTime(lastUpdate));

		fprintf(stderr, "\n Number of years? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->year = 0;
		else delta_rec->year = atoi(time);
		free(time);

		fprintf(stderr, " Number of months (1 month = 30 days)? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->mon = 0;
		else delta_rec->mon = atoi(time);
		free(time);

		fprintf(stderr, " Number of days? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->day = 0;
		else delta_rec->day = atoi(time);
		free(time);

		fprintf(stderr, " Number of hours? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->hour = 0;
		else delta_rec->hour = atoi(time);
		free(time);

		fprintf(stderr, " Number of minutes? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->minu = 0;
		else delta_rec->minu = atoi(time);
		free(time);

		fprintf(stderr, " Number of seconds? (CR for 0)   ");
                time = gets((char *)malloc(3));
		if(strlen(time) == 0) delta_rec->sec = 0;
		else delta_rec->sec = atoi(time);
		free(time);

		fprintf(stderr, "\n");
		if ((delta_rec->year == 0) && (delta_rec->mon == 0) && (delta_rec->day == 0)
		    && (delta_rec->hour == 0) && (delta_rec->minu == 0) && (delta_rec->sec == 0)) {
			fprintf(stderr, "\nNo nextUpdate specified!\n");
			goto nextupdate;
		}
		nextUpdate = delta_time_rec(lastUpdate, delta_rec);	
	}
	else {
		fprintf(stderr, "\nnextUpdate? (e.g. 8902232100+0100) ");
		nextUpdate = (UTCTime *)malloc(TIMELEN);
		if (!nextUpdate) {
			aux_add_error(EMALLOC, "nextUpdate", CNULL, 0, proc);
			fprintf(stderr, "Can't allocate memory");
			return (CNULL);
		}
		if ( !gets(nextUpdate) || !nextUpdate[0] ) {
			fprintf(stderr, "\nNo nextUpdate specified!\n");
			free (nextUpdate);
			return (CNULL);
		}
		if (aux_cmp_UTCTime(lastUpdate, nextUpdate)) {
			fprintf(stderr, "\n\nERROR: nextUpdate earlier than lastUpdate!\n");
			free (nextUpdate);
			free(timetype);
			goto nextupdate;
		}
	}
	return (nextUpdate);
}


UTCTime * get_date_of_expiry()
{
	static T_REC   * delta_rec = (T_REC * )0;
	UTCTime	       * current, * dateOfExpiry;
	char           * proc = "get_date_of_expiry";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif


	if(! delta_rec){
		delta_rec = (T_REC *)malloc(sizeof(T_REC));
		if(! delta_rec){
			aux_add_error(EMALLOC, "delta_rec", CNULL, 0, proc);
			return((UTCTime * )0);
		}
		delta_rec->year = 0;
		delta_rec->mon = 0;
		delta_rec->day = 0;
		delta_rec->hour = 0;
		delta_rec->minu = 10;
		delta_rec->sec = 0;
	}

	current = aux_current_UTCTime();
	dateOfExpiry = delta_time_rec(current, delta_rec);
	free(current);
	
	return(dateOfExpiry);
}

