/*
 *  SecuDE Release 4.1 (GMD)
 */
#ifdef MAC
#include <string.h>
#endif /* MAC */
#include "secure.h"
#ifdef TEST
#include <stdio.h>
#endif


/************* external functions: ***************************/

char	*strcpy(), *strcat();

/************* char string subfunctions imported**************/
/************* from EAN Version 1 str.h/str.c   **************/

char * cpystr( str )
char * str;
{
	char	* new;
	char	* proc = "cpystr";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	new = malloc(strlen(str) + 1);
	if (!new) {
		aux_add_error(EMALLOC, new, CNULL, 0, proc);
		return (CNULL);
	}
	return( strcpy( new, str ) );
}


catstr( ptr_str, ptr_len, new )
char**	ptr_str;
int*	ptr_len;
char*	new;
{
	char	* mal;
	char	* proc = "catstr";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !new ) 
		return(0);
	*ptr_len += strlen( new );
	mal = malloc(*ptr_len);
	if (!mal) {
		aux_add_error(EMALLOC, "mal", CNULL, 0, proc);
		return(0);
	}
	new = strcat( strcpy(mal, *ptr_str), new );
	free( *ptr_str );
	*ptr_str = new;

	return(0);
}


char*
str_low( str )
char*	str;
{
	char	*s;

	for ( s = str; *s; ++s ) 
		if ( *s >= 'A' && *s <= 'Z' ) 
			*s += 'a' - 'A';
	return( str );
}


char*
str_up( str )
char*	str;
{
	char	*s;

	for ( s = str; *s; ++s ) 
		if ( *s >= 'a' && *s <= 'z' ) 
			*s -= 'a' - 'A';
	return( str );
}



Trim( str )
char*	str;
{
	char * 	s;

	s = &str[strlen(str)];
	while ( --s >= str && (*s == ' ' || *s == '\t') ) 
		*s = '\0';

	return(0);
}


int
Skip_blanks( str, ptr_idx )
char*	str;
int*	ptr_idx;
{
	char	c;

	while ( (c = str[*ptr_idx]) == ' ' || c == '\t' ) 
		++(*ptr_idx);
	return( c != '\0' );
}


int
ScanOp( str, ptr_idx, oper )
char*	str;
int*	ptr_idx;
char*	oper;
{
	char	c;

	while ( (c = str[*ptr_idx]) == ' ' || c == '\t' ) 
		++(*ptr_idx);
	if ( !strchr(oper, c)) 
		return( FALSE );
	++(*ptr_idx);
	return( TRUE );
}


char * Scanv( str, ptr_idx, delim )
char *	str;
int  *	ptr_idx;
char *	delim;
{
	char	* token, c;
	int	  i, j;
	char	* proc = "Scanv";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !Skip_blanks(str, ptr_idx) ) 
		return( FALSE );
	for ( i = (*ptr_idx); 
	    (c = str[i]) != '\0' && c != '\n' && !strchr(delim, c); ++i)
		;
	if ( (i -= *ptr_idx) == 0 ) 
		return (CNULL);
	token = malloc( i + 1 );
	if (!token) {
		aux_add_error(EMALLOC, "token", CNULL, 0, proc);
		return (CNULL);
	}

	for ( j = 0; j < i; ++j ) 
		token[j] = str[(*ptr_idx)++];
	token[j] = '\0';
	return( token );
}


