/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/
#include "secure.h"
#ifdef TEST
#include <stdio.h>
#endif

#ifdef MAC
#include <stdlib.h>
#endif /* MAC */


OctetString *aux_canon(text)
/* canonicalize text into canform:
    transform CR or LF or CRLF or LFCR to CRLF */

OctetString *text;
{
	OctetString * canform; /*returncode*/
	int	x, i;
	char	c, d, CR, LF;
	char	*proc = "aux_canon";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !(canform = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "canform", CNULL, 0, proc);
		return( (OctetString * )0 );
	}
	canform->noctets = 2 * text->noctets; /*worst case: only CR's*/
	if ( !(canform->octets = malloc(canform->noctets)) ) {
		aux_add_error(EMALLOC, "canform->octets", CNULL, 0, proc);
		free(canform);
		return( (OctetString * )0 );
	}

	i = x = 0;
	CR = 0x0d; /*test with CR='D'*/
	LF = 0x0a; /*test with LF='A'*/

	while (i < text->noctets) {
		c = *(text->octets + i++);
		if ( c == LF || c == CR ) {
			if ( i < text->noctets ) {
				d = *(text->octets + i);
				if ( c == LF )
					if ( d == CR ) {
						*(canform->octets + x++) = d;
						*(canform->octets + x++) = c;
						i++;
					}
					else {
						*(canform->octets + x++) = CR;
						*(canform->octets + x++) = c;
					}
				else if /*c==CR*/
				( d == LF ) {
					*(canform->octets + x++) = c;
					*(canform->octets + x++) = d;
					i++;
				} else {
					*(canform->octets + x++) = c;
					*(canform->octets + x++) = LF;
				}
			} else {
				*(canform->octets + x++) = CR;
				*(canform->octets + x++) = LF;
			}
		} else {
			*(canform->octets + x++) = c;
		}
	} /*while*/

	canform->noctets = x;
	canform->octets = (char *)realloc(canform->octets, canform->noctets);
	return(canform);
}  /* end aux_canon() */



OctetString *aux_decanon(canform)
/* decanonicalize canform into text:
    transform CRLF or LFCR or CR or LF to a NewLine ('\n', which is ==LF);
    delete padding-octets 0xFF appended to canform from text. */

OctetString *canform;
{
	OctetString * text; /*returned*/
	int	x, i;
	char	c, d, CR, LF, NL;
	char	*proc = "aux_decanon";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !(text = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "text", CNULL, 0, proc);
		return( (OctetString * )0 );
	}
	text->noctets = canform->noctets; /*worst case: can't be longer*/
	if ( !(text->octets = malloc(text->noctets)) ) {
		aux_add_error(EMALLOC, "text->octets", CNULL, 0, proc);
		free(text);
		return( (OctetString * )0 );
	}

	i = x = 0;
	CR = 0x0d; /*test with CR='D'*/
	LF = 0x0a; /*test with LF='A'*/
	NL = '\n'; /*test with NL='N'*/

	while (i < canform->noctets) {
		c = *(canform->octets + i++);
		if ( c == LF || c == CR ) {
			*(text->octets + x++) = NL;
			if ( i < canform->noctets ) {
				d = *(canform->octets + i);
				if ( ((c == LF) && (d == CR)) || ((c == CR) && (d == LF)) )
					i++;
			}
		} else
			*(text->octets + x++) = c;
	} /*while*/

	text->noctets = x;
	while ( *(text->octets + text->noctets - 1) == -1 )
		text->noctets--;
	text->octets = (char *)realloc(text->octets, text->noctets);
	return( text );
}  /* end aux_decanon() */



OctetString *aux_64(text, indent)
/* copy text into form64 and
    insert indent and one CR after every 64 octets into form64 */

OctetString *text;
OctetString *indent;
{
	OctetString * form64; /*return*/
	int	lind;
	int	index = 0;
	int	i = 0;
	char	NL = '\n';
	char	*proc = "aux_64";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !(form64 = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "form64", CNULL, 0, proc);
		return( (OctetString * )0 );
	}
	form64->noctets = text->noctets + (text->noctets / 64 + 1) * (indent->noctets + 1);
	/*every 64 char`s: indent + one CR*/
	if ( !(form64->octets = malloc(form64->noctets)) ) {
		aux_add_error(EMALLOC, "form64->octets", CNULL, 0, proc);
		free(form64);
		return( (OctetString * )0 );
	}

	while ( i < text->noctets ) {
		for (lind = 0; lind < indent->noctets; lind++)
			*(form64->octets + index++) = *(indent->octets + lind);
		for (lind = 0; (lind < 64) && (i < text->noctets); lind++)
			*(form64->octets + index++) = *(text->octets + i++);
		*(form64->octets + index++) = NL;
	}    /* while */
	form64->noctets = index;
	form64->octets = (char *)realloc(form64->octets, form64->noctets);
	return( form64 );
}  /* end aux_64() */



OctetString *aux_de64(form64, indentlen)
/* copy form64 into text and
    remove every 64 char's: indentlen+1 char's from text */

OctetString *form64;
int	indentlen;
{
	OctetString * text; /*return*/
	int	lind;
	int	index = 0;
	int	i;
	char	*proc = "aux_de64";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !(text = (OctetString * )malloc(sizeof(OctetString))) ) {
		aux_add_error(EMALLOC, "text", CNULL, 0, proc);
		return( (OctetString * )0 );
	}
	text->noctets = form64->noctets; /*worst case: can't be longer*/
	if ( !(text->octets = malloc(text->noctets)) ) {
		aux_add_error(EMALLOC, "text->octets", CNULL, 0, proc);
		free(text);
		return( (OctetString * )0 );
	}
	for ( i = indentlen; i < form64->noctets; i = i + indentlen ) {
		for ( lind = 0; (lind < 64) && (i < form64->noctets); lind++)
			*(text->octets + index++) = *(form64->octets + i++);
		/* skip CR-LF or CR or LF: */
		if ( (i < form64->noctets) && (form64->octets[i] == '\r') )
			i++;
		if ( (i < form64->noctets) && (form64->octets[i] == '\n') )
			i++;
	}
	if (text->octets[index - 1] == '\n') 
		index--;
	if (text->octets[index - 1] == '\r') 
		index--;
	text->octets = (char *)realloc(text->octets, index);
	text->noctets = index;
	return( text );
}     /* end aux_de64() */


