/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/

#ifndef MAC
#include <sys/types.h>
#include <sys/stat.h>
#else
#include "MacTypes.h"
#include "Mac.h"
#endif /* MAC */

#include <fcntl.h>
#include <stdio.h>
#include "secure.h"

#ifdef DOS
typedef unsigned char u_char;
typedef unsigned long u_long;
struct hex_overlay {u_long b0, b1, b2, b3; };
#endif

typedef
union {
	struct {
		u_long b0, b1, b2, b3;
	} w;  /*for xdump, fxdump*/
	char	c[16];
}       XBUF;


/*
void  aux_xdump( buffer, len, addrtype);
void  aux_xdump2( buffer, len, addrtype, printable);
void  aux_fxdump( dump_file, buffer, len, addrtype);
void  aux_fxdump2( dump_file, buffer, len, addrtype, printable);

   schreibt nach stdout/dump_file den Eingabe puffer
   im Dumpformat
   addrtype ==  n(>=0): relative Adressen beginnend bei n
	    == -1     : absolute Adressen

adresse  hexadezimalformat                         text
000 000  00000000 00000000  00000000 00000000     |................|
000 010  und so weiter bis Ende des Puffers
*/



void aux_fxdumpp( dump_file, buffer, len, addr_type,printable)
char    *buffer;
int     len, addr_type;
FILE* dump_file;
Boolean printable;
{
        XBUF hex_buf;
        char    buf_line[17];                /* work area */
        char    dump_line[33];               /* hex output line */

        char    buf_address[7];
        char    *rel_address;


#ifdef DOS
        struct hex_overlay *ptr_hex_line = (struct hex_overlay *) buf_line;
        int  j;
        char bit;
        int n;
        int p;
        int index;
#endif

        buf_line[16] = '\0';     /* delimiter */

        if ( addr_type == -1 )
                /* absolute */ rel_address = buffer;
        else /* relative */
                rel_address = NULL;


        for (; len > 0 ; buffer += 16 ) {
                int     i;

                /* copy to work area */
                for (i = 0; i < 16; len--) {
                        buf_line[i] = (len > 0) ? buffer[i] : ' ';
                        i++;
                }
#ifdef DOS
                memcpy(hex_buf.c,buf_line,16);
#else
                bcopy(buf_line, hex_buf.c, 16);
#endif

                /* convert address */
#ifdef DOS
                sprintf(buf_address, "%02X", rel_address);
#else
                sprintf(buf_address, "%6lX", rel_address);
#endif

#ifdef DOS

                /* convert hex */

                n = 8;
                p = 7;
                index = 0;
                for (j =0; j<4; j++)
                {
                  bit = ((ptr_hex_line->b0 >> (p+1-n)) &~(~0 << n));
                  p += 8;
                  sprintf(&dump_line[index],"%02x",bit & 0xff);
                  index += 2;
                }
                p = 7;
                for (j =0; j<4; j++)
                {
                 bit = ((ptr_hex_line->b1 >> (p+1-n)) &~(~0 << n));
                 p += 8;
                 sprintf(&dump_line[index],"%02x",bit & 0xff);
                 index += 2;
                }
                p = 7;
                for (j =0; j<4; j++)
                {
                  bit = ((ptr_hex_line->b2 >> (p+1-n)) &~(~0 << n));
                  p += 8;
                  sprintf(&dump_line[index],"%02x",bit & 0xFF);
                  index += 2;
                 }
                 p = 7;
                 for (j =0; j<4; j++)
                 {
                   bit = ((ptr_hex_line->b3 >> (p+1-n)) &~(~0 << n));
                   p += 8;
                   sprintf(&dump_line[index],"%02x",bit & 0xff);
                   index += 2;
                  }
#else
                sprintf(dump_line,
                  "%08lX%08lX%08lX%08lX",
                  hex_buf.w.b0,
                  hex_buf.w.b1,
                  hex_buf.w.b2,
                  hex_buf.w.b3
                  );
#endif

                /* clear invisible part */
                if (len < 0) {
                        char    *clr;
                        for ( clr = dump_line + 32 + 2 * len;
                            clr < dump_line + 32; clr++
                            )
                                *clr = ' ';
                }


                /* convert to printable */
                for (i = 0; i < 16; i++)
                        if (buf_line[i] < 0x20 || buf_line[i] >= 0x7F)
                                buf_line[i] = '.';


                /* ... and print with linefeed */
	 	if (printable)
	 	{
#ifdef DOS
                  fprintf(dump_file,
                    "%-.3s %-.8s %-.8s  %-.8s %-.8s      |%s|\n",
                     buf_address,
                     dump_line+0,
                     dump_line+8,
                     dump_line+16,
                     dump_line+24,
                     buf_line
                  );
#else
                  fprintf(dump_file,
                    "%-.3s %3s  %-.8s %-.8s  %-.8s %-.8s      |%s|\n",
                    buf_address, buf_address + 3,
                    dump_line + 0,
                    dump_line + 8,
                    dump_line + 16,
                    dump_line + 24,
                    buf_line
                    );

#endif

		}
		else
	 	{
#ifdef DOS
                  fprintf(dump_file,
                    "%-.3s %-.8s %-.8s  %-.8s %-.8s      |%s|\n",
                     buf_address,
                     dump_line+0,
                     dump_line+8,
                     dump_line+16,
                     dump_line+24,
                     buf_line
                  );
#else
                  fprintf(dump_file,
                    "%-.3s %3s  %-.8s %-.8s  %-.8s %-.8s\n",
                    buf_address, buf_address + 3,
                    dump_line + 0,
                    dump_line + 8,
                    dump_line + 16,
                    dump_line + 24
                    );

#endif

		}


                rel_address += 16;
        }

}

void aux_fxdump( dump_file, buffer, len, addr_type)
char	*buffer;
int	len, addr_type;
FILE*dump_file;
{
	aux_fxdumpp(dump_file, buffer, len, addr_type, TRUE);
}


void aux_fxdump2( dump_file, buffer, len, addr_type)
char	*buffer;
int	len, addr_type;
FILE*dump_file;
{
	aux_fxdumpp(dump_file, buffer, len, addr_type, FALSE);
}


void aux_xdump (buffer, len, addr_type)
char	*buffer;
int	len, addr_type;
{
	aux_fxdumpp(stdout, buffer, len, addr_type, TRUE);
	return;
}


void aux_xdump2 (buffer, len, addr_type)
char	*buffer;
int	len, addr_type;
{
	aux_fxdumpp(stdout, buffer, len, addr_type, FALSE);
	return;
}


