;****************************************************************
;**           :
;** Project   : Personal Logic Debugger (PLD)
;** Filename  : CSET.ASM
;** Author    : Don Lekei
;** Status    : Experimental
;** Date      : 08/27/93
;** Purpose   : TRANSLATION TABLE for LCD DISPLAY TEXT
;**           :
;****************************************************************
;

; This sets up a translation table for the LCD DISPLAY so that the TEXT*
; directives can translate directly to LCD segment patterns without

;          a  		
;        ##### 		Each bit turns on a segment. 
;     f #     # b	The translation table converts
;       #  g  #		ASCII text to tables (using RETLW) 
;        ##### 		of LCD patterns to display the
;     e #     # c	desired characters.
;       #     #		
;        #####    #h	This uses an under-documented feature
;          d		of the assembler to set individual
;			characters in the character set. (This
;                       was intended to leave holes for 3-2 packing
;                       shift characters).
;
;
;The backplane configuration determines the bit order. Bits are sent to
;the LCD (display dependant) as:
;	-BP1---- -BP2---- -BP3----
; MSB   S1,S2,S3,S1,S2,S3,S1,S2,S3  LSB
;       h, c, d, b, g, e, *, a, f
;
; * = legend: Digit 1 - [E], Digit 2 - [M], Digit 3 - [-] : not in byte
;
;
s_	=	0			;Place holder for OFF segment



sf	=	^0			;Bit for this Segment
sa	=	^1			;byte is shifted out
sd	=	^2			;msb first
sc	=	^3			;
sh	=	^4			;
se	=	^5			;
sg	=	^6			;
sb	=	^7			;
dp	=	4			;bit # for decimal point

;************************************************************************
;
; Building the table using these variables makes it easier to use different 
; glass (LCD) which has a different segment/backplane matrix.
; there are some missing characters as duplicate patterns are not allowed.
; also, substituting alternate characters may give improved appearance. Where
; only one case of a letter could be displayed, the letter was used as
; uppercase (eg. Y displays y, B displays b, O displays o, etc. )
;
; For example "YE5" for "yes" and "MO" for NO ("No" for "no") 
;
;************************************************************************

CS_LCD	.CSET	(s_|s_|s_|s_|s_|s_|s_|s_)," "		;(SPACE)
	.CSET	(s_|sb|sc|s_|s_|s_|s_|sh),"!"		;!
	.CSET	(s_|sb|s_|s_|s_|sf|s_|s_),'"'		;"
	.CSET	(s_|sb|sc|s_|se|sf|s_|s_),"#"		;#
	.CSET	(s_|sb|s_|s_|s_|s_|s_|s_),"'"		;'
	.CSET	(s_|s_|s_|s_|se|s_|s_|s_),","		;'
	.CSET	(s_|s_|s_|s_|s_|s_|sg|s_),"-"		;-
	.CSET	(s_|s_|s_|s_|s_|s_|s_|sh),"."		;.
	.CSET	(s_|sb|s_|s_|se|s_|sg|s_),"/"		;/
	.CSET	(sa|sb|sc|sd|se|sf|s_|s_),"0"		;0
	.CSET	(s_|sb|sc|s_|s_|s_|s_|s_),"1"		;1
	.CSET	(sa|sb|s_|sd|se|s_|sg|s_),"2"		;2
	.CSET	(sa|sb|sc|sd|s_|s_|sg|s_),"3"		;3
	.CSET	(s_|sb|sc|s_|s_|sf|sg|s_),"4"		;4
	.CSET	(sa|s_|sc|sd|s_|sf|sg|s_),"5"		;5
	.CSET	(sa|s_|sc|sd|se|sf|sg|s_),"6"		;6
	.CSET	(sa|sb|sc|s_|s_|s_|s_|s_),"7"		;7
	.CSET	(sa|sb|sc|sd|se|sf|sg|s_),"8"		;8
	.CSET	(sa|sb|sc|sd|s_|sf|sg|s_),"9"		;9
	.CSET	(sa|s_|s_|sd|s_|s_|s_|s_),":"		;:
	.CSET	(sa|s_|sc|s_|s_|s_|sg|s_),";"		;;
	.CSET	(s_|s_|s_|sd|s_|s_|sg|s_),"="		;=
	.CSET	(sa|sb|s_|s_|se|s_|sg|s_),"?"		;?
	.CSET	(sa|sb|s_|sd|se|sf|sg|s_),"@"		;@
	.CSET	(sa|sb|sc|s_|se|sf|sg|s_),"A"		;A
	.CSET	(s_|s_|sc|sd|se|sf|sg|s_),"B"		;b
	.CSET	(s_|s_|s_|sd|se|sf|sa|s_),"C"		;C
	.CSET	(s_|sb|sc|sd|se|s_|sg|s_),"D"		;d
	.CSET	(s_|sb|sc|sd|se|s_|sg|sh),"d"		;d. (for logo)
	.CSET	(sa|s_|s_|sd|se|sf|sg|s_),"E"		;E
	.CSET	(sa|s_|s_|s_|se|sf|sg|s_),"F"		;F
	.CSET	(sa|s_|sc|sd|se|sf|s_|s_),"G"		;G
	.CSET	(s_|sb|sc|s_|se|sf|sg|s_),"H"		;H
	.CSET	(s_|s_|s_|s_|se|sf|s_|s_),"I"		;I
	.CSET	(sa|sb|sc|sd|se|s_|s_|s_),"J"		;J
	.CSET	(s_|s_|s_|sd|se|sf|s_|sh),"l"		;L. (for logo)
	.CSET	(s_|s_|s_|sd|se|sf|s_|s_),"L"		;L
	.CSET	(sa|sb|sc|s_|se|sf|s_|s_),"M"		;big n
	.CSET	(s_|s_|sc|s_|se|s_|sg|s_),"N"		;n
	.CSET	(sa|sb|s_|s_|se|sf|sg|s_),"P"		;P
	.CSET	(sa|sb|s_|s_|se|sf|sg|sh),"p"		;P. (for logo)
	.CSET	(sa|sb|sc|sd|se|sf|s_|sh),"Q"		;O.
	.CSET	(sa|sb|s_|s_|se|sf|s_|s_),"R"		;big r
	.CSET	(sa|s_|s_|s_|se|sf|s_|s_),"T"		;backwards 7
	.CSET	(s_|sb|sc|sd|se|sf|s_|s_),"U"		;U
	.CSET	(s_|sb|s_|s_|se|sf|sg|s_),"V"		;backwards 4
	.CSET	(s_|sb|sc|sd|se|sf|sg|s_),"W"		;W
	.CSET	(s_|sb|sc|sd|s_|sf|sg|s_),"Y"		;y
	.CSET	(sa|s_|s_|sd|s_|s_|sg|s_),"Z"		;
	.CSET	(s_|s_|sc|s_|s_|sf|sg|s_),"\"		;\
	.CSET	(sa|sb|sc|sd|s_|s_|s_|s_),"]"		;]
	.CSET	(sa|sb|s_|s_|s_|sf|s_|s_),"^"		;^
	.CSET	(s_|s_|s_|sd|s_|s_|s_|s_),"_"		;_
	.CSET	(s_|s_|s_|s_|s_|sf|s_|s_),"`"		;`
	.CSET	(sa|sb|sc|sd|se|s_|sg|s_),"a"		;a
	.CSET	(s_|s_|s_|sd|se|s_|sg|s_),"c"		;c
	.CSET	(s_|s_|sc|s_|se|sf|sg|s_),"h"		;h
	.CSET	(s_|s_|sc|s_|s_|s_|s_|s_),"i"		;i
	.CSET	(s_|sb|sc|sd|se|s_|s_|s_),"j"		;j
	.CSET	(s_|s_|s_|sd|se|sf|sg|s_),"k"		;k
	.CSET	(s_|s_|sc|sd|se|s_|sg|s_),"o"		;o
	.CSET	(s_|s_|s_|s_|se|s_|sg|s_),"r"		;r
	.CSET	(s_|s_|sc|sd|se|s_|s_|s_),"u"		;u
	.CSET	(s_|sb|sc|s_|s_|s_|sg|s_),"{"		;{
	.CSET	(s_|s_|s_|s_|se|sf|sg|s_),"}"		;}

	.cset = CS_LCD	;initiate translation using above table
