/****************************************************************************
 Module
         f:\icc11\testing\testall1.c

 Revision
         1.0.1

 Description
         First combined test module for testing ICC11

 Notes
         

 History
 When           Who	What/Why
 -------------- ---	--------
 02/19/94 09:30 jec	 first pass
 02/20/94 08:38 jec   added |= & function call in calc tests
****************************************************************************/

/*----------------------------- Include Files -----------------------------*/
#include <stdio.h>

#define PASS 1
#define FAIL 0
#define SMALL_CONST 3

/*---------------------------- Module Functions ---------------------------*/
void PassFail(int iLetter, int iNumber, int iPassed);
int ReturnInt(void);

/*---------------------------- Module Variables ---------------------------*/
	/* for OR EQU test */
static const unsigned int Toggle[2]={ 4, 1};
volatile unsigned int OrTarget;


/*------------------------------ Module Code ------------------------------*/
void
main(void)
{
   /* tests unsigned int modulo */
   {
      unsigned int rem = 0xffff;

      rem = rem % 16;
      if ( rem != 0xf)
         PassFail('A','1',FAIL);
      else
         PassFail('A','1',PASS);
   }

		/* test problem with unsigned divide */
   {
   	unsigned int i;
   	unsigned int base;
   
   	i = 0x0f;
   	base = 16;
   
   	i = i/base;
   	if(i !=0)
         PassFail('A','2',FAIL);
      else
         PassFail('A','2',PASS);
   }

   /*	bug1.c demonstrates the problem with unary minus */

   {
      int uint = 1;
   
      if ((-uint) != (-1*uint))
         PassFail('A','3',FAIL);
      else
         PassFail('A','3',PASS);
   }

   /*	bug2.c demonstrates the problem with unsigned char promotion to int */

   {
      unsigned char ucChar = SMALL_CONST;
      int iInt;
      int iInt2 = 0xffff;    /* force accA to have something in it */

	   iInt = ucChar;			/* should promote to int, iInt == SMALL_CONST */
	   iInt2 = SMALL_CONST;
      if ((iInt) != (iInt2))
         PassFail('A','4',FAIL);
      else
         PassFail('A','4',PASS);
   }

   /* bug3.c const - unsigned char subtraction problem */

	{
		unsigned char speed = 50;

		if((100 - speed) != 50)
			PassFail('A','5',FAIL);
		else
			PassFail('A','5',PASS);
   }	

   /* oreqbug.c logical OR problem */

	{
		unsigned char Channel = 1;

		OrTarget = 0xf0;
		OrTarget |= Toggle[Channel];
		if (OrTarget != 0xf1)
        	PassFail('A','6',FAIL);
      	else
         	PassFail('A','6',PASS);
	}

	/* function call in calc over-write bug */
	{
		int iResult;
		int iAnyVal = 10;

		iResult = ReturnInt() + iAnyVal;
		if ((iResult != (10+SMALL_CONST)) || (iAnyVal != 10))
			PassFail('A','7', FAIL);
		else
			PassFail('A','7', PASS);
	}
	

}



void
PassFail(int iLetter, int iNumber, int iPassed)
{
   putchar(iLetter);
   putchar(iNumber);
   if (iPassed)
      puts(" Passed");
   else
      puts(" ------>Failed\a");
}
	/* ReturnInt is part of function call overwrite bug test */

int
ReturnInt(void)
{
	return(SMALL_CONST);
}
/*------------------------------- Footnotes -------------------------------*/

/*------------------------------ End of file ------------------------------*/


