/*  UTILS.H -- Header for the utility functions
 *
 *  Copyright (C) by Jarkko Vuori 1992
 *  Author(s): J Vuori
 *  Modification(s):
 */

#define MAX_FILES   2

typedef enum { True = -1, False = 0 } Bool;

typedef enum {
    p = 0x01,	// bit 0: data/pgm
    x = 0x00,	// bit 1: x/y
    y = 0x02
} DATASPACE;

typedef struct {
    unsigned char space;
    unsigned	  address,
		  len;
} BLKHEADER;

typedef struct {
    char			    cmd;
    Bool			    numericArgument, fDescription;
    char			   *usage;
    enum { Modify, ReadOnly, Last } fileModes[MAX_FILES+1];
    char			   *extension[MAX_FILES];
    Bool		    (cdecl *operation)(FILE *files[], ...);
} CMDS;

unsigned  crc(unsigned char *blk, unsigned len);
char	 *AddExtension(char *FileName, char *Extension);
int	  ParseCommands(int argc, char *argv[], CMDS *cmds, int cmdcount, int desc_len, void (*usage)(void));
Bool	  ReadBlocks(FILE *fp, Bool (*block)(BLKHEADER *pHeader, long huge *data));
