%  WARNING!!  For the expert MATLAB user only!  This only shows the way
%  our calculations were made.  It is NOT a general case file for modifying
%  the coefficients in the compander.
%
%  TABLES.M  generates the tables of coefficients for the COMPAND
%  program that runs on TI's DSP Starter Kit TMS320C26 board, and puts those
%  into the proper include files.
clear; 
%	SET UP YOUR FREQUENCIES HERE!
fs = 10e3;  	%10 KHz sampling rate.
M = 100; 
n = -(M/2)+1:1:M/2;
%
%  l*(f3-f2) must = fs or the lookup table will not be finite where l is an
% 	integer.
%  In this case m is 8.
f1 = 176; 	%the low frequency for the low filter.
f2 = 626;	%the high frequency for the low filter/low frequency for the
		%high receive filter.		.
f3 = 1251;	%the low frequency for the high transmitt filter.
f4 = 2500;	%the high frequency for the high transmitt filter.
f5 = f4-f3+f2;	%the high frequency for the high receive filter.

% Compute the exponential tables here.
l = 0:fs./(f3-f2)-1;	% 16*625 = 10000
%  Check the sign on this shift.
expary = exp(i*2*pi*(f3-f2)*l/fs);
exparyr = round(real(expary)*(2.^15-1));	%round these and scale them.
exparyi = round(imag(expary)*(2.^15-1));	%round these and scale them.

% 	COMPUTE THE FILTER COEFFICIENTS

% We will use a real filter since we don't need to shift the low frequency
% part.
hlow = fir1(M-1,[2*f1/fs,2*f2/fs],kaiser(M,3));

% This part generates the analytic signal as well as doing the filtering to
% give the upper band for the transmit filter.
hhight = (-i/pi)./n.*(exp((i*2*pi*f4/fs).*n) - exp((i*2*pi*f3/fs).*n));
hhight(M/2) = (f4-f3)*2/fs;
hhight= hhight .* kaiser(M,3)'; %  Window it with a Kaiser window. 

% This part generates the analytic signal as well as doing the filtering to 
% give the upper band for the receive filter.
hhighr = (-i/pi)./n.*(exp((i*2*pi*f5/fs).*n) - exp((i*2*pi*f2/fs).*n));
hhighr(M/2) = (f5-f2)*2/fs;
hhighr= hhighr .* kaiser(M,3)'; %  Window it with a Kaiser window. 

% This part rounds the numbers and scales them up by 2^16.
hlow = round(real(hlow/max(hlow).*(2.^14-1)));
hhighrt = round(real(hhight)./max(abs(hhight)).*(2.^14-1));
hhighit = round(imag(hhight)./max(abs(hhight)).*(2.^14-1));
hhighrr = round(real(hhighr)./max(abs(hhighr)).*(2.^14-1));
hhighir = round(imag(hhighr)./max(abs(hhighr)).*(2.^14-1));

% This section computes the frequency response curves.
f = -fs/2:8:fs/2;	% This is the frequency axis variable for the plots.
H = zeros(size(f));	% H is the frequency curve for the low filter.
for m = -(M/2)+1:1:M/2;
	H = H + hlow(m+M/2)*exp((-i*2*pi/fs*m).*f);
end
H2r = zeros(size(f));	% H2r is the frequency curve for the high receive filt.
for m = -(M/2)+1:1:M/2;
	H2r = H2r + (hhighrr(m+M/2)+i*hhighir(m+M/2))*exp((-i*2*pi/fs*m).*f);
end
H2t= zeros(size(f));	% H2t is the frequency curve for the high receive filt.
for m = -(M/2)+1:1:M/2;
	H2t = H2t + (hhighrt(m+M/2)+i*hhighit(m+M/2))*exp((-i*2*pi/fs*m).*f);
end

%  We want the same passband heights on all filters so we make it so here!
hlow = round(hlow/max(abs(H))*max(abs(H2t)));

%  Redo the low filter frequency response to see that it has been scaled
%  correctly.
H = zeros(size(f));	% H is the frequency curve for the low filter.
for m = -(M/2)+1:1:M/2;
	H = H + hlow(m+M/2)*exp((-i*2*pi/fs*m).*f);
end


%  Plot the frequency response curves.
plot(f,20*log(abs(H)),f,20*log(abs(H2r)),f,20*log(abs(H2t)));

% 	WRITE out the files here.
%	Write the low filter file.
fid = fopen('COEF.ASM','w');
fprintf(fid,'COEF1_R .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n',hlow);
%	Write the transmitt files.
fprintf(fid,'COEF2R_T .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n',hhighrt);
fprintf(fid,'COEF2T_I .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n',hhighit);

%	Write the receive files.
fprintf(fid,'COEF2R_R .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n',hhighrr);
fprintf(fid,'COEF2R_I .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n',hhighir);

%	Write the exponential file.
fidexp = fopen('EXP.ASM','w');
fprintf(fidexp,'EXP_R .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n',exparyr);
fprintf(fidexp,'EXP_I .word %d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n',exparyi);
