/*
 * this file is part of "The W Toolkit".
 *
 * (W) 1996, Kay Roemer.
 */
#ifndef _WT_H
#define _WT_H

/*
 * additional input/output
 */

void wt_delinput (long handle);
long wt_addinput (fd_set *r, fd_set *w, fd_set *e,
		void (*cb) (long arg, fd_set *r, fd_set *w, fd_set *e),
		long arg);

/*
 * timeouts
 */

void wt_deltimeout (long handle);
long wt_addtimeout (long millisecs, void (*cb) (long arg), long arg);

/*
 * widget class
 */
struct _widget_t;

typedef struct _widget_class_t {
	char *name;
	short initialized;

	long (*init) (void);

	struct _widget_t *(*create) (struct _widget_class_t *);
	long (*delete) (struct _widget_t *w);

	long (*close) (struct _widget_t *w);
	long (*open) (struct _widget_t *w);

	long (*addchild) (struct _widget_t *parent, struct _widget_t *w);
	long (*delchild) (struct _widget_t *parent, struct _widget_t *w);

	long (*realize) (struct _widget_t *w, WWIN *parent);

	long (*query_geometry) (struct _widget_t *w,
				long *x, long *y, long *wd, long *ht);

	long (*setopt) (struct _widget_t *w, long key, void *value);
	long (*getopt) (struct _widget_t *w, long key, void *value);

	long (*event) (struct _widget_t *w, WEVENT *);

	long (*child_change) (struct _widget_t *w, struct _widget_t *child,
			      short what);

	long (*parent_change) (struct _widget_t *w, struct _widget_t *parent,
			       short what);
} widget_class_t;

/*
 * changes mask for child_change(), parent_change()
 */
#define WT_CHANGED_SIZE		0x01
#define WT_CHANGED_POS		0x02

/*
 * widget instance
 */
typedef struct _widget_t {
	struct _widget_t *next, *prev;
	struct _widget_t *parent, *childs;

	widget_class_t *class;

	int x, y, w, h;

	long usrval;

	WWIN *win;
} widget_t;

/*
 * generic options used for different widgets. to the right is the argument
 * type for use with wt_setopt() and wt_getopt().
 *
 * NOTE: new options for your own widgets should be > 500.
 */
#define WT_EOL		0	/* none  */

#define WT_WIDTH	1	/* long* */
#define	WT_HEIGHT	2	/* long* */
#define	WT_XPOS		3	/* long* */
#define	WT_YPOS		4	/* long* */

#define WT_ORIENTATION	5	/* long* */
#define	    OrientHorz		1L
#define     OrientVert		0L

#define WT_ALIGNMENT	6	/* long* */
#define     AlignLeft		(-1L)
#define     AlignTop		AlignLeft
#define     AlignRight		1L
#define     AlignBottom		AlignRight
#define     AlignCenter		0L

#define WT_LABEL	7	/* char* */
#define WT_FONT		8	/* char* */
#define WT_USRVAL	9	/* long* */
#define WT_EVENT_MASK	10	/* long* */

#define WT_DRAW_FN	11	/* void (*) (widget_t *, int, int, int, int) */

#define	WT_RESIZE_CB	12	/* unused at the moment */
#define	WT_EVENT_CB	13	/* void (*) (widget_t *, WEVENT *) */
#define WT_ACTION_CB	14	/* depends */

#define WT_STATE	19	/* long* */
#define	    ButtonStateReleased	0L
#define	    ButtonStatePressed	1L

#define WT_MODE		20	/* long* */
#define	    ButtonModePush	0L
#define	    ButtonModeRadio	1L
#define	    ButtonModeToggle	2L

#define     LabelModeNoBorder	3L
#define     LabelModeWithBorder	ButtonModePush

#define     ShellModeMain	0L
#define     ShellModePopup	1L
#define     ShellModeNoBorder	2L

#define     HTMLModeFixed	0L
#define     HTMLModeGrow	1L

#define     ViewpModeLazyScroll	0L
#define     ViewpModeLifeScroll	1L

#define     GetstrModeNoBorder	0L
#define     GetstrModeWithBorder 1L

#define WT_HDIST	21	/* long* */
#define WT_VDIST	22	/* long* */

/*
 * these are (mostly) scrollbar-specific
 */
#define WT_SIZE		15	/* long*,  within 0, ..., ScrollbarScale */
#define WT_POSITION	16	/* long*,  within 0, ..., ScrollbarScale */
#define WT_LINE_INC	17	/* long*,  within 0, ..., ScrollbarScale */
#define WT_PAGE_INC	18	/* long*,  within 0, ..., ScrollbarScale */
#define     ScrollbarScale	1024

/*
 * these are iconedit-specific
 */
#define WT_ICON_WIDTH	30	/* long* */
#define WT_ICON_HEIGHT	31	/* long* */
#define WT_ICON_XPOS	32	/* long* */
#define WT_ICON_YPOS	33	/* long* */
#define WT_UNIT_SIZE	34	/* long* */

/*
 * these are HTML specific
 */
#define WT_APPEND	40	/* char* */
#define WT_QUERY_CB	42	/* long (*) (widget_t*, char*, int*, int*) */
#define WT_PLACE_CB	43	/* void (*) (widget_t*, long, int, int) */
#define WT_INVAL_CB	44	/* void (*) (widget_t*, int) */

/*
 * these are `getstring' specific
 */
#define WT_STRING_ADDRESS	50	/* char* */
#define WT_STRING_LENGTH	51	/* long* */
#define WT_STRING_WIDTH		52	/* long* */

/*
 * widget support functions. needed when using widgets.
 */
extern widget_t *wt_init (void);
extern widget_t *wt_create (widget_class_t *class, widget_t *parent);
extern long	 wt_delete (widget_t *w);
extern long	 wt_open (widget_t *);
extern long	 wt_close (widget_t *);
extern long	 wt_realize (widget_t *top);
extern long	 wt_run (void);
extern long	 wt_break (long r);
extern long	 wt_getopt (widget_t *, ...);
extern long	 wt_setopt (widget_t *, ...);
extern WWIN	*wt_widget2win (widget_t *);

/*
 * available widget classes
 */
extern widget_class_t *wt_top_class;
extern widget_class_t *wt_shell_class;

extern widget_class_t *wt_box_class;
extern widget_class_t *wt_pane_class;
extern widget_class_t *wt_form_class;
extern widget_class_t *wt_viewport_class;

extern widget_class_t *wt_pushbutton_class;
extern widget_class_t *wt_radiobutton_class;
extern widget_class_t *wt_checkbutton_class;
extern widget_class_t *wt_label_class;

#define wt_button_class	wt_pushbutton_class

extern widget_class_t *wt_drawable_class;
extern widget_class_t *wt_scrollbar_class;
extern widget_class_t *wt_iconedit_class;
extern widget_class_t *wt_html_class;
extern widget_class_t *wt_getstring_class;

/*
 * helper functions. these are needed when implementing new widgets.
 */
extern void	wt_box3d (WWIN *, int x, int y, int wd, int ht);
extern void	wt_box3d_press (WWIN *, int x, int y, int wd, int ht, int);
extern void	wt_box3d_release (WWIN *, int x, int y, int wd, int ht, int);
extern void	wt_box3d_mark (WWIN *, int x, int y, int wd, int ht);
extern void	wt_box3d_unmark (WWIN *, int x, int y, int wd, int ht);
extern void	wt_circle3d (WWIN *, int x, int y, int r);
extern void	wt_circle3d_press (WWIN *, int x, int y, int r);
extern void	wt_circle3d_release (WWIN *, int x, int y, int r);
extern void	wt_circle3d_mark (WWIN *, int x, int y, int r);
extern void	wt_circle3d_unmark (WWIN *, int x, int y, int r);
extern void	wt_arrow3d (WWIN *, int x, int y, int w, int h, int dir);
extern void	wt_arrow3d_press (WWIN *, int x, int y, int w, int h, int dir);
extern void	wt_arrow3d_release (WWIN *, int x, int y, int w, int h, int d);
extern void	wt_text (WWIN *, WFONT *fp, char *str,
			 int x, int y, int w, int h, int align);

extern void	wt_remove (widget_t *);
extern void	wt_add_before (widget_t *par, widget_t *w, widget_t *new);
extern void	wt_add_after (widget_t *par, widget_t *w, widget_t *new);

extern void	wt_change_notify (widget_t *, short changes);
extern WWIN	*wt_create_window (WWIN *parent, short wd, short ht, short fl);

#endif
