/*
 * this file is part of WetScape, a Web browser for the W window system.
 * Copyrigt (C) 1996 Kay Roemer.
 *
 * MIME related stuff.
 *
 * $Id: mime.h,v 1.1.1.1 1996/04/05 16:42:36 yak Exp $
 */
#ifndef _MIME_H
#define _MIME_H

#define MIME_DEFAULT	"text/plain"

struct _io_t;

typedef struct _decoder_t {
	int  (*create) (struct _io_t *);
	int  (*decode) (struct _io_t *);
	void (*free) (struct _io_t *);
} decoder_t;

extern char*	mime_get_type (char *ext);
extern decoder_t* mime_get_decoder (char *type);
extern char*	mime_get_command (char *type);
extern int	mime_input_handler (struct _io_t *);

#endif
