/*
 * window.h, part of W
 * (C) 94-01/96 Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * (w) 1996, kay Roemer.
 */

#ifndef _WINDOW_H
#define _WINDOW_H


extern WINDOW *glob_rootwindow, *glob_activewindow, *glob_activetopwin, *glob_backgroundwin;
extern short globOpenWindows, globTotalWindows;

extern long window_init ();
extern WINDOW *window_create (WINDOW *parent, int flags);
extern long window_delete (WINDOW *);
extern long window_open (WINDOW *, int x, int y);
extern long window_open_all (WINDOW *, int x, int y);
extern long window_close (WINDOW *);
extern long window_move (WINDOW *, int x, int y);
extern long window_to_top (WINDOW *);
extern long window_to_bottom (WINDOW *);
extern WINDOW *window_find (int x, int y, int usecache);
extern int window_save_contents_rect (WINDOW *, void *rect);
extern int window_redraw_contents_rect (WINDOW *, void *rect);
extern WINDOW *wtree_traverse_pre (WINDOW *wtree, void *arg,
				   int (*f) (WINDOW *, void *));
extern void windowKillClient(CLIENT *cptr);
extern void windowActivate(WINDOW *win);
extern WINDOW *windowLookup (ushort id);
extern void windowDeactivate(WINDOW *win);
extern void windowRedrawAllIfDirty(void);

extern void windowDrawFrame (WINDOW *win, int dashed, int tobitmap, REC *clip);

#endif
