/*
 * cursor_on()/cursor_off()/clear_scr() and makeraw().
 *
 * ++kay.
 *
 * CHANGES:
 * - NetBSD seems to have no termcap.h :( , Phx 02/96
 */

#include <stdio.h>
#include <stdlib.h>
#include <termios.h>
#ifdef __NetBSD__
extern int tgetent(char *, char *);
extern char *tgetstr(char *, char **);
extern void tputs(register char *, int, int (*)());
#else
#include <termcap.h>
#endif

static char *termname = NULL;
static char buffer[512];
static char cap[512];

static int
init (void)
{
	if (termname)
		return 0;
	if (!(termname = getenv ("TERM"))) {
		fprintf (stderr, "wserver: TERM not set\n");
		return 1;
	}
	if (tgetent (buffer, termname) != 1) {
		termname = NULL;
		fprintf (stderr, "wserver: unknown terminal type\n");
		return 1;
	}
	return 0;
}

int
tputchar (int c)
{
	return putc (c, stdout);
}

void
cursor_on (void)
{
	char *cp = cap;

	if (init())
		return;
	cp = tgetstr ("ve", &cp);
	tputs (cp, 1, tputchar);
}

void
cursor_off (void)
{
	char *cp = cap;

	if (init())
		return;
	cp = tgetstr ("vi", &cp);
	tputs (cp, 1, tputchar);
}

void
clear_scr (void)
{
	char *cp = cap;

	if (init())
		return;
	cp = tgetstr ("cl", &cp);
	tputs (cp, 1, tputchar);
}

void
makeraw (struct termios *tt)
{
	tt->c_iflag &= ~(IGNBRK|BRKINT|PARMRK|ISTRIP|INLCR|IGNCR|
			ICRNL|IXON);
	tt->c_oflag &= ~OPOST;
	/*
	 * NOTE: we dont clear IEXTEN, so we sill still get
	 * cursor key mapping. (when disabling IEXTEN I get
	 * 0x00 for all cursor key presses and cursor keys
	 * don't work under Mint).
	 *
	 * ++kay.
	 */
	tt->c_lflag &= ~(ECHO|ECHONL|ICANON|ISIG);
	tt->c_cflag &= ~(CSIZE|PARENB);
	tt->c_cflag |= CS8;
}
