/*
 * server/proto.h, part of W
 * (C) 1994,95,96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#ifndef __W_PROTO_H
#define __W_PROTO_H


/*
 * these weird macros allocate memory regions which have one long before and
 * one long behind them accessible without memory errors and therefore save
 * us a lot of checks and thus execution time. the only drawback is: you must
 * under no circumstances mix them with the normal malloc/free calls!
 */

#define MALLOC(size) (void *)(((ulong)malloc(size+8))+4)
#define FREE(addr) free((void *)(((ulong)addr)-4))


/*
 * global stuff
 *
 * EV_KEYS and EV_MOUSE already defined in ../lib/Wlib.h
 */

#define	EV_UCONN 0x0001
#define	EV_ICONN 0x0002
#define	EV_CLIENT 0x0004

/* indexes to glob_font[] array */
#define TITLEFONT 0
#define	MENUFONT 1

#include "graph/gproto.h"


/* in client_*.c */

extern void client_do_close (WINDOW *);
extern void client_do_delete (WINDOW *);
extern void client_do_open (WINDOW *);

extern long client_create(CLIENT *cptr, short width, short height,
			  short flags, WWIN *libPtr);
extern long client_create2(CLIENT *cptr, short width, short height,
			   short flags, ushort handle, WWIN *libPtr);
extern short client_open(CLIENT *cptr, ushort handle, short x0, short y0);
extern short client_move(CLIENT *cptr, ushort handle, short x0, short y0);
extern short client_resize(CLIENT *cptr, ushort handle, short width, short height);
extern short client_close(CLIENT *cptr, ushort handle);
extern short client_delete(CLIENT *cptr, ushort handle);
extern void client_loadfont(CLIENT *cptr, char *family, short size,
			    short styles, LFONTRETP *lfontrpaket);
extern short client_unloadfont(CLIENT *cptr, short fonthandle);
extern short client_querywinsize(CLIENT *cptr, ushort handle, short effective,
				 short *width, short *height);
extern void client_setmode(CLIENT *cptr, ushort handle, short mode);
extern short client_test(CLIENT *cptr, ushort handle, short x0, short y0);
extern void client_setfont(CLIENT *cptr, ushort handle, short fonthandle);
extern void client_settextstyle(CLIENT *cptr, ushort handle, short flags);
extern short client_querymousepos(CLIENT *cptr, ushort handle, short *x0,
				  short *y0);
extern short client_querywindowpos(CLIENT *cptr, ushort handle, short effective,
				   short *x0, short *y0);
extern void client_setpattern(CLIENT *cptr, ushort handle, ushort pattern);
extern void client_settitle(CLIENT *cptr, ushort handle, char *s);
extern void client_plot(CLIENT *cptr, ushort handle, short x0, short y0);
extern void client_line(CLIENT *cptr, ushort handle, short x0, short y0,
			short xe, short ye);
extern void client_hline(CLIENT *cptr, ushort handle, short x0, short y0,
			 short xe);
extern void client_vline(CLIENT *cptr, ushort handle, short x0, short y0,
			 short ye);
extern void client_box(CLIENT *cptr, ushort handle, short x0, short y0,
		       short width, short height);
extern void client_poly(CLIENT *cptr, ushort handle, short numpoints, short *points);
extern void client_bezier(CLIENT *cptr, ushort handle, short *controls);
extern void client_bitblk(CLIENT *cptr, ushort handle, short x0, short y0,
			  short width, short height, short x1, short y1);
extern void client_bitblk2(CLIENT *cptr, ushort shandle, short x0, short y0,
			   short width, short height, ushort dhandle, short x1,
			   short y1);
extern void client_vscroll(CLIENT *cptr, ushort handle, short x0, short y0,
			   short width, short height, short y1);
extern void client_printc(CLIENT *cptr, ushort handle, short x0, short y0,
			  ushort c);
extern void client_prints(CLIENT *cptr, ushort handle, short x0, short y0,
			  uchar *s);
extern void client_circle(CLIENT *cptr, ushort handle, short x0, short y0,
			  short r);
extern void client_ellipse(CLIENT *cptr, ushort handle, short x0, short y0,
			  short rx, short ry);
extern short client_status(CLIENT *cptr, CLIENT *clients, short index,
			   STATUS *status);
extern long client_putblockreq (CLIENT *cptr, short width, short height,
				ushort handle, short x0, short y0, long shmKey);
extern void client_putblockdata(CLIENT *cptr, char *rawdata, short space);
extern long client_getblockreq(CLIENT *cptr, ushort handle, short x0, short y0,
			       short width, short height, long shmKey);
extern short client_getblockdata(CLIENT *cptr, char *rawdata, short space);
extern void client_beep(CLIENT *cptr);

extern short clientAllocColor(CLIENT *cptr, ushort handle,
			      ushort red, ushort green, ushort blue);
extern short clientFreeColor(CLIENT *cptr, ushort handle, short color);
extern void clientChangeColor(CLIENT *cptr, ushort handle, short color,
			      ushort red, ushort green, ushort blue);
extern void clientSetColor(CLIENT *cptr, ushort handle, short color);
extern short clientAllocColorRange(CLIENT *cptr, ushort handle,
				   short colors, short start);


/* in color.c */

extern COLORTABLE *glob_colortable;
extern short colorCopyVirtualTable (WINDOW *win, WINDOW *parent);
extern short colorFreeTable (WINDOW *win);
extern void colorGetMask (short color, ushort *mask);
extern short colorInit (void);
extern void colorSetColorTable (COLORTABLE *colTab, short force);
extern short colorAllocColor (WINDOW *win,
			    uchar newRed, uchar newGreen, uchar newBlue);
extern short colorFreeColor (WINDOW *win, short color);
extern short colorChangeColor (WINDOW *win, short color,
			     uchar red, uchar green, uchar blue);
extern short colorSetFGColor (WINDOW *win, short color);
extern short colorSetBGColor (WINDOW *win, short color);


/* in font.c */

extern FONT glob_font[MAXFONTS];
extern int font_init(char *title_font, char *menu_font);
extern short font_loadfont(char *fontname);
extern short font_unloadfont(FONT *fp);
extern int fontStrLen(FONT *f, char *s);


/* in graph/init.c */
extern SCREEN *screen_init(int forceMono);
extern REC *clip0, *clip1;
extern GCONTEXT *gc0;


/* in kbd.h */

extern int glob_kbd;
extern int kbdInit(void);


/* in main.c */

extern SCREEN *glob_screen;
extern int glob_unixh, glob_ineth;
extern short glob_uid;
extern int glob_debug;
extern char *glob_fontpath;
extern char *glob_fontfamily;
extern short glob_fontsize;
extern short is_terminating;
extern void terminate(int sig, char *msg);
extern void wserver_exit(int sig, char *msg);
extern void *mysignal(int signum, void *);


/* in loop.c */

extern int get_rectangle(short width, short height, short *x0, short *y0,
			  char pressed, char released);
extern long glob_savecount, glob_savetime;
extern long get_eventmask(long wanted, long timeout, fd_set *retrfd);
extern WEVENT *event_mouse(void);
extern WINDOW *glob_leftmousepressed, *glob_rightmousepressed;
extern long glob_bytes, glob_pakets;
extern CLIENT *glob_clients;
extern fd_set glob_crfd;
extern short glob_pakettype;
extern void loop (void);


/* in menu.c */

extern void menu_domenu (void);
extern MENU menu;


/* in misc.c */

extern short intersect(short x0, short y0, short width0, short height0,
		       short x1, short y1, short width1, short height1);
extern REC *wrec_intersect(REC *rec1, REC *rec2);
extern void set_defaultgc(WINDOW *win);


/* in mouse.c */

extern MOUSE glob_mouse;
extern short wmouse_init (void);
extern void mouse_exit (void);
extern void mouse_show (void);
extern void mouse_hide (void);
extern void mouse_move (void);
extern short mouse_rcintersect (short x0, short y0, short width, short height);


/* in recs.c */

#if 0
extern short glob_recsused;
extern WREC glob_rec[MAXRECS];
extern void recs_rebuild(void);
extern void recUpdateDirty(REC *r, int x0, int y0, int width, int height);
#endif


/* in term.c */

struct termios;
extern void cursor_on (void);
extern void cursor_off (void);
extern void clear_scr (void);
extern void makeraw (struct termios *tt);


/* in wfuncs_???.c */

extern void w_topDown(WINDOW *win);
extern void w_changeActiveWindow(void);

#endif /* __W_PROTO_H */
