/*
 * server/mouse.c, part of W
 * (C) 1994,95,96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * 11/96 ++TeSche: multiple mouse pointer support
 */

#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef __MINT__
# include <mintbind.h>
#endif
#ifdef SVGALIB
#include <vga.h>
#endif
#include "config.h"
#include "types.h"
#include "pakets.h"
#include "proto.h"
#include "window.h"

/* global variable */
MOUSE glob_mouse;


#define mouseNormal \
"ooooooooooo....."\
"o*********o....."\
"o*********o....."\
"o*********o....."\
"o******oooo....."\
"o*******o......."\
"o********o......"\
"o***o*****o....."\
"o***oo*****o...."\
"o***o.o*****o..."\
"ooooo..o*****o.."\
"........o*****o."\
".........o****o."\
"..........o**o.."\
"...........oo..."\
"................"


#define mouseLeftRight \
"................"\
"................"\
"................"\
"....oo....oo...."\
"...o**o..o**o..."\
"..o**o....o**o.."\
".o**oooooooo**o."\
"o**************o"\
"o**************o"\
".o**oooooooo**o."\
"..o**o....o**o.."\
"...o**o..o**o..."\
"....oo....oo...."\
"................"\
"................"\
"................"


#define mouseUpDown \
".......oo......."\
"......o**o......"\
".....o****o....."\
"....o******o...."\
"...o**o**o**o..."\
"...o*oo**oo*o..."\
"....o.o**o.o...."\
"......o**o......"\
"......o**o......"\
"....o.o**o.o...."\
"...o*oo**oo*o..."\
"...o**o**o**o..."\
"....o******o...."\
".....o****o....."\
"......o**o......"\
".......oo......."


#define mouseUpperLeftLowerRight \
"ooooooooo......."\
"o*******o......."\
"o*******o......."\
"o****oooo......."\
"o*****o........."\
"o**o***o........"\
"o**oo***o..oooo."\
"o**o.o***o.o**o."\
"oooo..o***oo**o."\
".......o***o**o."\
"........o*****o."\
"......oooo****o."\
"......o*******o."\
"......o*******o."\
"......ooooooooo."\
"................"


#define mouseLowerLeftUpperRight \
".......ooooooooo"\
".......o*******o"\
".......o*******o"\
".......oooo****o"\
".........o*****o"\
"........o***o**o"\
".oooo..o***oo**o"\
".o**o.o***o.o**o"\
".o**oo***o..oooo"\
".o**o***o......."\
".o*****o........"\
".o****oooo......"\
".o*******o......"\
".o*******o......"\
".ooooooooo......"\
"................"


static MOUSEPOINTER realPointer[5] = {
  {mouseNormal, 0, 0},
  {mouseLeftRight, -8, -8},
  {mouseUpDown, -8, -8},
  {mouseUpperLeftLowerRight, -8, -8},
  {mouseLowerLeftUpperRight, -8, -8},
};


static MOUSEPOINTER *indexedPointer[16];


static void decode (char *pattern, ushort *mask, ushort *icon)
{
  short height = 16;

  while (--height >= 0) {

    ushort maskval = 0, iconval = 0, bit = 0x8000;

    while (bit) {

      switch (*pattern++) {

        case '*':
	  iconval |= bit;
	  /* fall through */

        case 'o':
	  maskval |= bit;
	  break;

	default:
      }

      bit >>= 1;
    }

    *mask++ = maskval;
    *icon++ = iconval;
  }
}


static inline MOUSEPOINTER *getPointerType (void)
{
  WINDOW *win;
  int x = glob_mouse.real.x0, y = glob_mouse.real.y0, idx = 0;

  if (!(win = window_find (x, y, 1)))   /* this should never happen */
    return indexedPointer[0];

  if (!(win->flags & W_RESIZE))
    return indexedPointer[0];

  if (y - win->pos.y0 < 4)
    idx |= 1;   /* upper edge */

  if (win->pos.y1 - y < 4)
    idx |= 2;   /* lower edge */

  if (x - win->pos.x0 < 4)
    idx |= 4;   /* left edge */

  if (win->pos.x1 - x < 4)
    idx |= 8;   /* right edge */

  return indexedPointer[idx];
}


/*
 * the exported functions
 */

/* SVGALIB already has a function named 'mouse_init', so I renamed this */
short wmouse_init (void)
{
  int i;

#ifdef SVGALIB
  /* has to be called before screen_init (->vga_setmode) */
  vga_setmousesupport (1);
  glob_mouse.fh = 0;
#else
  if ((glob_mouse.fh = open ("/dev/mouse", O_RDONLY | O_NDELAY)) < 0)
    return 1;
#endif

  /* decode graphics
   */
  for (i=0; i<5; i++)
    decode (realPointer[i].pattern, realPointer[i].mask, realPointer[i].icon);

  /* now set up an indexed array of pointers so that we can easily get the
   * correct pointer type by oring together bitmasks based on the following
   * descisions:
   *
   * 0x1 = pointer is over the upper edge
   * 0x2 = pointer is over the lower edge
   * 0x4 = pointer is over the left edge
   * 0x8 = pointer is over the right edge
   */

  indexedPointer[0] = &realPointer[0];
  indexedPointer[1] = &realPointer[2];
  indexedPointer[2] = &realPointer[2];
  indexedPointer[3] = &realPointer[0];
  indexedPointer[4] = &realPointer[1];
  indexedPointer[5] = &realPointer[3];
  indexedPointer[6] = &realPointer[4];
  indexedPointer[7] = &realPointer[0];
  indexedPointer[8] = &realPointer[1];
  indexedPointer[9] = &realPointer[4];
  indexedPointer[10] = &realPointer[3];
  indexedPointer[11] = &realPointer[0];
  indexedPointer[12] = &realPointer[0];
  indexedPointer[13] = &realPointer[0];
  indexedPointer[14] = &realPointer[0];
  indexedPointer[15] = &realPointer[0];

  glob_mouse.disabled = 0;
  glob_mouse.visible = 0;

  return 0;
}


/*
 * hardware specific routine will set 'drawn' = 'real' values
 */

void mouse_show (void)
{
  if (glob_mouse.visible || glob_mouse.disabled)
    return;

  glob_mouse.visible = 1;
  (*glob_screen->mouseShow) (getPointerType ());
}


void mouse_hide (void)
{
  if (!glob_mouse.visible)
    return;

  glob_mouse.visible = 0;
  (*glob_screen->mouseHide) ();
}


short mouse_rcintersect (short x0, short y0, short width, short height)
{
  if (!glob_mouse.visible)
    return 0;

  return intersect (glob_mouse.drawn.x0, glob_mouse.drawn.y0,
		    glob_mouse.drawn.w, glob_mouse.drawn.h,
		    x0, y0, width, height);
}
