/*
 * server/misc.c, part of w
 * (C) 1994,95,96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * miscellaneous tool functions
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#ifdef __MINT__
# include <mintbind.h>
#endif
#include "config.h"
#include "types.h"
#include "pakets.h"
#include "proto.h"


static ushort bgColMask[8] = {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000};
static ushort fgColMask[8] = {0xffff,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000};

/*
 * set up the default GCONTEXT structure for this window
 */
void set_defaultgc(WINDOW *win)
{
  win->gc.drawmode = M_INVERS;
  win->gc.textstyle = F_NORMAL;
  win->gc.font = NULL;
  memcpy (win->patbuf, DefaultPattern, sizeof(win->patbuf));
  win->gc.pattern = win->patbuf;
  win->gc.bgCol = 0;
  win->gc.fgCol = (1 << glob_screen->bm.planes) - 1;
  memcpy (win->gc.bgColMask, bgColMask, sizeof(bgColMask));
  memcpy (win->gc.fgColMask, fgColMask, sizeof(fgColMask));
}


/*
 * just say yes or no when asking for intersection of
 * two rectangles
 */

short intersect (short x0, short y0, short width0, short height0, short x1, short y1, short width1, short height1)
{
  /* #0 is the mouse, #1 the other rectangle */

  /* is the lower edge of #1 above the upper edge of #0? */
  if (y1+height1-1 < y0)
    return 0;

  /* is the left edge of #1 right from the right edge of #0? */
  if (x1 > x0+width0-1)
    return 0;

  /* is the upper edge of #1 under the lower edge of #0? */
  if (y1 > y0+height0-1)
    return 0;

  /* is the right edge of #1 left from the left edge of #0? */
  if (x1+width1-1 < x0)
    return 0;

  /* must intersect somehow */
  return 1;
}


/*
 * this one calculates an intersection if there's any
 */

REC *wrec_intersect(REC *rec1, REC *rec2)
{
  static REC rec;

  if (rec2->x0 <= rec1->x0) {
    rec.x0 = rec1->x0;
    if ((rec.w = MIN(rec2->x0+rec2->w, rec1->x0+rec1->w) - rec1->x0) <= 0)
      return 0;
  } else {
    rec.x0 = rec2->x0;
    if ((rec.w = MIN(rec2->x0+rec2->w, rec1->x0+rec1->w) - rec2->x0) <= 0)
      return 0;
  }

  if (rec2->y0 <= rec1->y0) {
    rec.y0 = rec1->y0;
    if ((rec.h = MIN(rec2->y0+rec2->h, rec1->y0+rec1->h) - rec1->y0) <= 0)
      return 0;
  } else {
    rec.y0 = rec2->y0;
    if ((rec.h = MIN(rec2->y0+rec2->h, rec1->y0+rec1->h) - rec2->y0) <= 0)
      return 0;
  }

  return &rec;
}

