/*
 * server/kbd.c, part of W
 * (C) 1994,95,96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * CHANGES:
 *
 * Phx 02/96:
 * - included support for NetBSD-Amiga
 * Phx 06/96:
 * - global keymap structure for NetBSD
 */

#include <fcntl.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef __MINT__
# include <mintbind.h>
#endif

#include "config.h"
#include "types.h"
#include "pakets.h"
#include "proto.h"

#ifdef sun
#include <sundev/kbio.h>
#define KBD "/dev/kbd"
#endif

#ifdef __NetBSD__
#include <amiga/dev/iteioctl.h>
#include <amiga/dev/kbdmap.h>
#include <amiga/dev/kbdreg.h>
#define KBD "/dev/kbd"
#endif

/*
 *
 */

int glob_kbd;
#ifdef __NetBSD__
/* global keymap for rawkey translation
 */
struct kbdmap netbsd_kmap;
#endif


/*
 * the `big' init function for the keyboard...
 */

#if defined(__MINT__) || defined(linux)

int kbdInit(void)
{
  /* ... */
  glob_kbd = 0;
  return 0;

}

#elif defined(sun) || defined(__NetBSD__)

int kbdInit(void)
{
  int arg;

  if ((glob_kbd = open(KBD, O_RDONLY)) < 0) {
    fprintf(stderr, "error: can't open keyboard\r\n");
    return -1;
  }

#ifdef __NetBSD__
  /* determine active keymap for rawkey translations
   */
  if (ioctl (0, ITEIOCGKMAP, &netbsd_kmap)) {
    fprintf (stderr, "error: can't determine system keymap\r\n");
    return -1;
  }
#endif

  if (!glob_debug) {
    /* this will redirect all keyboard input to /dev/kbd rather than to the
     * systems console. since later, in wterm, we can only catch both input and
     * output for the console we must assure here that wserver still gets its
     * input.
     */
    arg = 1;
    ioctl(glob_kbd, KIOCSDIRECT, &arg);
  }

  return 0;
}

#else

#error operating system not supported by server/kbd.c

#endif
