/* svga_s3.h */

#define s3_index           0x3d4
#define s3_data            0x3d5
#define X_positiv       0x20
#define Y_positiv       0x80
#define Y_major         0x40
#define CUR_X           0x86e8
#define CUR_Y           0x82e8
#define DESTX_DIASTP    0x8ee8
#define DESTY_AXSTP     0x8ae8
#define ERR_TERM        0x92e8
#define MAJ_AXIS_PCNT   0x96e8
#define GP_STATUS       0x9ae8
#define CMD_REG         0x9ae8
#define SHORT_STROKE    0x9ee8
#define BKGD_COLOR      0xa2e8
#define FRGD_COLOR      0xa6e8
#define WRT_MASK        0xaae8
#define RD_MASK         0xaee8
#define BKGD_MIX        0xb6e8
#define FRGD_MIX        0xbae8
#define MULTIFUNC_CNTL  0xbee8
#define PIX_TRANS       0xe2e8


#define ACROSS          0x0100
#define BYTEWIDE        0x0200
#define READ            0x0400
#define SWAP            0x1000
#define DRAW            0x0010
#define LAST_OFF        0x0020


void Enable_S3 (void);
void Disable_S3 (void);
void Wait_Fifo (int fifo);
void Wait_Busy (void);
void Selekt_Bank (int bank);
void xline (int dir, int len, int x1, int y1);
void xlineto (int len, int dir);
void line (int x1, int y1, int x2, int y2, int pattern);
void Fill_Rectangle (int x1, int y1, int x2, int y2);
void Bit_Blit (int x1, int y1, int x2, int y2, int destx, int desty, int mix);
void Move_Screen (int x, int y);
void Set_Clip (int x1, int y1, int x2, int y2);
void Set_Paint_Style (int fg_color, int fg_mix,
	     int bg_color, int bg_mix, int re_mask, int wrt_mask);
void Short_Vector (int x, int y, int number, int vector []);
void Set_Palette (int first, int number, char *palette);
void Img_Trans (int x1, int y1, int x2, int y2, void *img, int mask);
void Maus_pattern (int zeile, int width, int height, char *pattern);
void Init_Maus (int pattern, int hot_x, int hot_y, int fg_color,
				      int bg_color);
void Disp_Maus (int on_off);
void Move_Maus (int x, int y);

/* */

void outpw(int port, int value);
void outpb(int port, int value);
int inpw(int port);
int inpb(int port);

extern int read_mask,frgd_mix,hot_x,hot_y,PLANE;
