/*   Bibliothek fr die direkte Programmierung des S3 86C911
     Programmiersprache : Quick-C 2.01
     Autor              : Jrgen Simon
*/

#include <stdio.h>
#include <stdlib.h>

#include "svga_s3.h"

int read_mask,frgd_mix,hot_x,hot_y,PLANE;


inline void outpw(int port, int value)
{
  __asm__ volatile 
    ("outw %0,%1" 
     :: "a"((unsigned short) value), "d"((unsigned short) port)
     );	    
}

inline void outpb(int port, int value)
{
  __asm__ volatile 
    ("outb %0,%1" 
     :: "a"((unsigned char) value), "d"((unsigned short) port)
     );	    
}

inline int inpw(int port)
{
  unsigned short value;
  __asm__ volatile 
    ("inw %1,%0" 
     : "=a"(value) 
     : "d"((unsigned short) port)
     );	    
  return value;
}

inline int inpb(int port)
{
  unsigned char value;
  __asm__ volatile 
    ("inb %1,%0" 
     : "=a"(value) 
     : "d"((unsigned short) port)
     );	    
  return value;
}


void Enable_S3 ()              /* erweiterte Register einschalten */
  {
  int help;
  outpb (s3_index,0x38);           /* Basisaddressen-Erweiterung */
  outpb (s3_data,0x48);
  outpb (s3_index,0x31);           /* einschalten */
  help=inpb(s3_data);
  outpb (s3_data,help | 1);        /* SC-Register fr Hardwarecursor */
  outpb (s3_index,0x39);
  outpb (s3_data,0xa0);            /* einschalten */
}

void Disable_S3 ()             /* erweiterte Register ausschalten */
{
  int help;
  outpb (s3_index,0x31);
  help = inpb(s3_data);
  outpb (s3_data,help & 0xfe);
  outpb (s3_index,0x38);
  outpb (s3_data,0);
  outpb (s3_index,0x39);
  outpb (s3_data,0);
  }

void Wait_Fifo (int fifo)      /* Wartet bis fifo Eintrge im S3 */
  {
  int help;                    /* frei sind */
  int st;
  help = 256 >> fifo;
  st = help;
  while ((st & 0xff) >= help) {
    st = inpw (GP_STATUS);
    printf("   status %i\n", st);
  }
}

void Wait_Busy ()              /* Wartet solange S3 arbeitet */
  {
  while (inpw (GP_STATUS) & 0x0200);
  }

void Wait_Read ()              /* Wartet bis Lesedaten bereit */
  {
  while (!(inpw (GP_STATUS) & 0x0100));
  }

void Selekt_Bank (int bank)    /* Blendet 64 kB-Bank in Seg A000 */
  {
  int help;
  bank &= 0x0f;
  outpb (s3_index, 0x35);
  help = inpb (s3_data);    /* Bankselekt Register einlesen */
  help &= 0xf0;         /* Die oberen vier Bit enthalten andere */
  help |= bank;         /* Informationen und sollten nicht */
  outpb (s3_data, help);    /* gendert werden. */
  }

void xline (int dir, int len, int x, int y)  /* Vektor von x y */
  {
  Wait_Fifo (5);
  outpw (MULTIFUNC_CNTL, 0xa000);            /* mit Lnge len und */
  outpw (CUR_X, x);
  outpw (CUR_Y, y);                          /* Richtung dir */
  outpw (MAJ_AXIS_PCNT, len);
  outpw (CMD_REG, 0x200b | ((dir & 7) << 5) | (dir & DRAW)
					| ((dir & LAST_OFF) >> 3));
  }

/* Die xline Befehle enthalten zwei Optionen, die in dir bergeben werden.

   DRAW     :  Nur wenn DRAW gesetzt ist wird gezeichnet, sonst wird
	       nur der Grafikcursor bewegt.
   Last_Off :  Wenn LAST_OFF gesetzt ist wird der Letzte Punkt nicht
	       gezeichnet.
   Beispiel :  xline (4 | DRAW | LAST_OFF, 40, 100, 100)  */

void xlineto (int dir, int len) /* Vektor von aktueller Cursor- */
  {
  Wait_Fifo (3);                /* Position mit Lnge len und */
  outpw (MULTIFUNC_CNTL, 0xa0000);
  outpw (MAJ_AXIS_PCNT, len);         /* Richtung dir */
  outpw (CMD_REG, 0x200b | ((dir & 7) << 5) | (dir & DRAW)
					| ((dir & LAST_OFF) >> 3));
  }

void line (int x1, int y1, int x2, int y2, int pattern)
  {
  int deltax,deltay,maximum,minimum,command,i;
  deltax=abs(x2-x1);
  deltay=abs(y2-y1);
  maximum=deltax > deltay? deltax: deltay; /* Zieht Linie von x1 / y1 nach */
  minimum=deltax < deltay? deltax: deltay;
  if (y1<y2)                      /* x2 / y2. */
    {
    command = Y_positiv;          /* Pattern enthlt ein 16 Bit */
    }
  else                            /* Muster. Wenn Pattern -1 ist, */
    {
    command = 0;                  /* dann wird eine durchgezogene */
    }
  if (deltax<=deltay)             /* Linie gezeichnet */
    {
    command |= Y_major;
    }
  Wait_Fifo (1);
  if (pattern==0xffff)
    {
    outpw (MULTIFUNC_CNTL, 0xa000);
    }
  else
    {
    outpw (MULTIFUNC_CNTL, 0xa080);
    command |= 0x300;
    }
  Wait_Fifo (7);
  outpw (CUR_X, x1);
  outpw (CUR_Y, y1);
  outpw (MAJ_AXIS_PCNT, maximum);
  outpw (DESTX_DIASTP, 2 * (minimum - maximum));
  outpw (DESTY_AXSTP, 2 * minimum);
  if (x1<x2)
    {
    outpw (ERR_TERM, 2 * minimum - maximum - 1);
    command |= X_positiv;
    }
  else
    {
    outpw (ERR_TERM, 2 * minimum - maximum);
    }
  outpw (CMD_REG, (0x2013 | command));
  if (pattern!=0xffff)
    {
    Wait_Fifo (1);
    for (i=0; i<((maximum/16)+1); i++)
      {
      outpw (PIX_TRANS, pattern);
      }
    }
  }

void Fill_Rectangle (int x1, int y1, int x2, int y2)
  {
  int deltax,deltay,command;     /* Zeichnet ein geflltes Rechteck */
  deltax = abs(x2-x1);
  deltay = abs(y2-y1);           /* Die Koordinaten knnen in */
  if (y1<y2)
    {                            /* beliebiger Reihenfolge stehen. */
    command = Y_positiv;
    }
  else
    {
    command = 0;
    }
  if (x1<x2)
    {
    command |= X_positiv;
    }
  Wait_Fifo (6);
  outpw (MULTIFUNC_CNTL, 0xa000);
  outpw (CUR_X, x1);
  outpw (CUR_Y, y1);
  outpw (MAJ_AXIS_PCNT, deltax);
  outpw (MULTIFUNC_CNTL, deltay);
  outpw (CMD_REG, (0x4013 | command));
  }

void Bit_Blit (int x1, int y1, int x2, int y2, int destx, int desty,
						int mix)
  {
  int deltax, deltay, command;    /* Bit Blit innerhalb d. Bildsp. */
  deltax = x2-x1;
  deltay = y2-y1;                 /* x1/y1: links oben Quelle */
  if ((destx<x2) && (destx>x1))
    {                             /* x2/y2: rechts unten Quelle */
    x1=x2;
    destx += deltax;              /* destx/desty: links oben Ziel */
    command = 0;
    }                             /* mix: Mischart oder ACROSS */
  else
    {                             /* mix setzt vorbergehend die durch */
    command = X_positiv;
    }                             /* Set_Paint_Style festgelegte Misch- */
  if ((desty<y2) && (desty>y1))
    {                             /* art auer Kraft. */
    y1=y2;
    desty += deltay;              /* Wird "mix | ACROSS" angegeben, dann */
    }
  else                            /* wird die Quelle als Zweifarbiges */
    {
    command |= Y_positiv;         /* Bitimmage aufgefasst. */
    }
  Wait_Fifo (2);
  if (mix==ACROSS)
    {
    outpw (MULTIFUNC_CNTL, 0xa0c0);
    }
  else
    {
    outpw (MULTIFUNC_CNTL, 0xa000);
    outpw (FRGD_MIX, mix | 0x60);
    }
  Wait_Fifo (7);
  outpw (CUR_X, x1);
  outpw (CUR_Y, y1);
  outpw (DESTX_DIASTP, destx);
  outpw (DESTY_AXSTP, desty);
  outpw (MAJ_AXIS_PCNT, deltax);
  outpw (MULTIFUNC_CNTL, deltay);
  outpw (CMD_REG, 0xc013 | command);
  Wait_Fifo (1);
  outpw (FRGD_MIX, frgd_mix);
  }

void Img_Trans (int x1, int y1, int x2, int y2, void *img, int mask)
  {
  int command,deltax,deltay,count, *imgw;
  long i;
  char *imgb;
  deltax = x2-x1;                    /* Bit Blit zw. Bild- und */
  deltay = y2-y1;
  Wait_Fifo (7);                     /* Hauptspeicher */
  if (mask & ACROSS)
    {                                /* x1/y1 links oben Bildsp. */
    outpw (MULTIFUNC_CNTL, 0xa080);
    command = 0x41b3 | (mask & SWAP);/* x2/y2 rechts unten Bildsp. */
    count = (deltax+8)/8;
    }                                /* img Zeiger auf int o. char */
  else
    {
    outpw (FRGD_MIX, (mask & 0x0f) | 0x40);
    outpw (MULTIFUNC_CNTL, 0xa000);
    command = 0x41b1 | (mask & SWAP);/* mask Mischart und */
    if (PLANE)
      {                              /* READ,SWAP,BYTEWIDE,ACROSS */
      count = deltax+1;
      }                              /* A C H T U N G */
    else
      {                              /* Es sollten keine Immages ber- */
      count = (deltax+2)/2;
      }                              /* tragen werden, die grer als */
    }
  if ((mask & BYTEWIDE)==0)          /* 64 kB sind, da ein Segment- */
    {
    command |= BYTEWIDE;             /* bertrag nicht beachtet wird. */
    count = (count+1)/2;
    imgw = (int *)img;               /* mix setzt Set_Paint_Style */
    }
  else                               /* vorbergehend auer Kraft. */
    {
    imgb = (char *)img;              /* mix | READ liest ein Immage */
    }
  if (mask & READ)                   /* mix | SWAP vertauscht lo u. hi */
    {
    command &= 0xfffe;               /* Byte jedes bergenbenen Wortes */
    }
  count = (count)*(deltay + 1);      /* mix | BYTEWIDE bertrgt das */
  outpw (CUR_X, x1);
  outpw (CUR_Y, y1);                 /* Immage in Bytes statt in Worten */
  outpw (MAJ_AXIS_PCNT, deltax);
  outpw (MULTIFUNC_CNTL, deltay);    /* mix | ACROSS bertrgt ein zwei- */
  outpw (CMD_REG, command);
  if (mask & READ)                   /* farbiges Bitimmage. */
    {
    Wait_Read ();                      /* Diese Schleifen zur Ein- */
    for (i=0; i<count; i++)
      {                                /* bzw. Ausgabe der Images */
      if (mask & BYTEWIDE)
	{                              /* sollten in Assembler */
	*(imgb+i) = inpb (PIX_TRANS);
	}                              /* realisiert werden. */
      else
	{
	*(imgw+i) = inpw (PIX_TRANS);
	}
      }
    }
  else
    {
    Wait_Fifo (2);
    if (mask & BYTEWIDE)
      {
      for (i=0; i<count; i++)
	{
	outpb (PIX_TRANS, *(imgb+i));
	}
      }
    else
      {
      for (i=0; i<count; i++)
	{
	outpw (PIX_TRANS, *(imgw+i));
	}
      }
    }
  Wait_Fifo (1);
  outpw (FRGD_MIX, frgd_mix);
  }

void Short_Vector (int x, int y, int number, int vector [])
  {
  int i;                          /* Gibt die in vector [] bergebenen */
  Wait_Fifo (4);
  outpw (MULTIFUNC_CNTL, 0xa000); /* Short_Stroke_Vektoren ab x/y aus */
  outpw (CUR_X, x);
  outpw (CUR_Y, y);               /* number enthlt die Anzahl der Worte! */
  outpw (CMD_REG, 0x121f);
  for (i=0; i<number; i++)        /* Der erste Vektor steht im Low-Byte */
    {
    Wait_Fifo (1);
    outpw (SHORT_STROKE, vector [i]);
    }
  }

void Move_Screen (int x, int y)  /* Bewegt das Sichtfenster ber die */
  {                              /* gesammte Bildschirmflche */
  int help;
  outpb (s3_index, 0x0d);            /* 256 Farben 1024 * 1024 Pixel */
  outpb (s3_data, x & 0xff);
  outpb (s3_index, 0x0c);            /*  16 Farben 2048 * 1024 Pixel */
  outpb (s3_data, y & 0xff);
  outpb (s3_index, 0x31);
  help = (inpb (s3_data) & 0xcf) | ((y & 0x300) / 16);
  outpb (s3_data, help);
  }

void Set_Clip (int x1, int y1, int x2, int y2)
  {                                /* Clipping Rechteck setzen */
  Wait_Fifo (4);
  outpw (MULTIFUNC_CNTL, 0x1000 | y1);
  outpw (MULTIFUNC_CNTL, 0x2000 | x1);
  outpw (MULTIFUNC_CNTL, 0x3000 | y2);
  outpw (MULTIFUNC_CNTL, 0x4000 | x2);
  }

void Set_Paint_Style (int fg_color, int fg_mix, int bg_color, int bg_mix,
				     int rd_mask, int wrt_mask)
  {
  frgd_mix = fg_mix;     /* Setzt Farbe etc fr alle Funktionen */
  read_mask = rd_mask;
  Wait_Fifo (6);
  outpb (FRGD_COLOR, fg_color);
  outpb (BKGD_COLOR, bg_color);
  outpb (FRGD_MIX, fg_mix);
  outpb (BKGD_MIX, bg_mix);
  outpb (RD_MASK, rd_mask);
  outpb (WRT_MASK, wrt_mask);
  }

void Maus_Pattern (int zeile, int width, int height, char *pattern)
  {
  int i, j, word, bit,breite = 1023, pat [64][8];
  for (j=0; j<64; j++)
  {
  for (i=0; i<7; i+=2)        /* bertrgt das Muster des Maus- */
    {
    pat [j] [i]   = -1;       /* zeigers in den Bildspeicher. */
    pat [j] [i+1] = 0;
    }                         /* Dabei wird das Clipping gendert! */
  }
  for (i=0; i<height; i++)    /* 'zeile' ist die Bildzeile in der */
    {
    for (j=0; j<width; j++)   /* das Muster gespeichert wird. */
      {
      word= (j & 0x30) / 8;   /* 'zeile' sollte auerhalb des Sicht- */
      bit = 1<<(15-(j & 15));
      switch (*(pattern+i*width+j))   /* Fensters liegen */
	{
	case 0:
	  pat [i] [word] &= 0xffff-bit;/* Das Muster ist width Pixel */
	  break;
	case 1:                        /* breit und height Pixel hoch */
	  pat [i] [word] &= 0xffff-bit;
	case 3:                        /* *pattern zeigt auf */
	  pat [i] [word+1] |= bit;
	}                              /* char [height] [width] */
      }
    }
  if (!PLANE)
    breite = 2047;
  Set_Clip (0,0,breite,1023);
  Img_Trans (0,zeile,breite,zeile, &pat [0][0], 7);
  }

void Init_Maus (int zeile, int hotx, int hoty, int fg_color,
				 int bg_color)
  {
  outpb (s3_index, 0x4c);
  outpb (s3_data, zeile /256); /* aktiviert den Mauszeiger mit dem in */
  outpb (s3_index, 0x4d);
  outpb (s3_data, zeile & 255);/* 'zeile' abgelegten Muster */
  hot_x = hotx;
  hot_y = hoty;            /* hot_x, hot_y legen den Hot-Spot fest */
  outpb (s3_index, 0x0e);
  outpb (s3_data, fg_color);
  outpb (s3_index, 0x0f);
  outpb (s3_data, bg_color);
  }

void Disp_Maus (int on_off) /* schaltet den Mauszeiger ein bzw. aus */
  {
  int help;
  outpb (s3_index, 0x45);
  help = inpb (s3_data);
  if (on_off)
    outpb (s3_data, help | 0x1);
  else
    outpb (s3_data, help & 0xfe);
  }

void Move_Maus (int x, int y) /* Mauszeiger an Position x y bewegen */
  {
  int offset_x = 0, offset_y = 0;
  x = x - hot_x;
  if (x<0)
    {
    offset_x = abs (x);
    x = 0;
    }
  y = y - hot_y;
  if (y<0)
    {
    offset_y = abs (y);
    y = 0;
    }
  outpb (s3_index, 0x46);
  outpb (s3_data, x / 256);
  outpb (s3_index, 0x47);
  outpb (s3_data, x & 255);
  outpb (s3_index, 0x4e);
  outpb (s3_data, offset_x);
  outpb (s3_index, 0x48);
  outpb (s3_data, y /256);
  outpb (s3_index, 0x49);
  outpb (s3_data, y & 255);
  outpb (s3_index, 0x4f);
  outpb (s3_data, offset_y);
  }
