/*
 * server/graph/direct8/direct8_block.c, part of W
 * (C) 94-03/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * getblock/putblock routines for the DIRECT8 driver
 */

#include <stdio.h>
#include <stdlib.h>
#include "../../config.h"
#include "../../types.h"
#include "../../gproto.h"
#include "../clip.h"
#include "svga.h"


/*
 *
 */

static inline void d2pm(register uchar *slptr,
			register ulong *dlptr,
			register short width)
{
  register ulong dlbit = 0x80000000;
  register ulong dval = *dlptr;

  while (--width >= 0) {
    if (*slptr++) {
      dval |= dlbit;
    } else {
      dval &= ~dlbit;
    }
    if (!(dlbit >>= 1)) {
      *dlptr++ = dval;
      dlbit = 0x80000000;
      dval = *dlptr;
    }
  }
  *dlptr = dval;
}


BITMAP *svga_getblock(BITMAP *bm,
			 short x0,
			 short y0,
			 register short width,
			 register short height)
{
  BITMAP *ret;
  register uchar *sptr;
  register ulong *dptr;
  register long sbpl, dlpl;

  if ((width < 1) || (height < 1)) {
    return NULL;
  }

  if (!(ret = malloc (sizeof (BITMAP)))) {
    return NULL;
  }

  ret->width = width;
  ret->height = height;
  ret->type = BM_BLOCK;
  ret->unitsize = 1;
  ret->upl = ((width + 7) & ~7) >> 3;
  ret->planes = 1;
  if (!(ret->data = malloc (ret->upl * ret->height))) {
    free(ret);
    return NULL;
  }

  sbpl = bm->upl;
  sptr = (uchar *)bm->data + y0 * sbpl + x0;

  dptr = (ulong *)ret->data;
  dlpl = ret->upl;

  while (--height >= 0) {
    d2pm(sptr, dptr, width);
    sptr += sbpl;
    dptr += dlpl;
  }

  return ret;
}


static inline void pm2d(register uchar *sptr,
			register uchar *dptr,
			register short width)
{
  register uchar sbit = 0x80, sval = *sptr;

  while (--width >= 0) {
    if (sval & sbit) {
      *dptr++= 0xff;
    } else {
      *dptr++= 0x00;
    }
    if (!(sbit >>= 1)) {
      sbit = 0x80;
      sval = *++sptr;
    }
  }
}


void svga_putblock(BITMAP *bm0,
		      BITMAP *bm1,
		      short x1,
		      short y1)
{
  register uchar *dptr, *sptr;
  register long sbpl, dbpl;
  register short width = bm0->width;
  register short height = bm0->height;

  if ((width < 1) || (height < 1)) {
    return;
  }

  sbpl = bm0->upl;
  sptr = (uchar *)bm0->data;

  dbpl = bm1->upl;
  dptr = (uchar *)bm1->data + (y1 * dbpl) + x1;

  while (--height >= 0) {
    pm2d(sptr, dptr, width);
    sptr += sbpl;
    dptr += dbpl;
  }
}


