/*
 * server/graph/sun.c, part of W
 * (C) 94-07/96 TeSche (Torsten Scherer)
 * itschere@techfak.uni-bielefeld.de
 *
 * init code for Sun Sparcstations, CG6 only so far
 */

#ifdef sun

#include <fcntl.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <sun/fbio.h>
#include <sundev/cg6reg.h>
#include "../config.h"
#include "../types.h"
#include "gproto.h"
#include "direct8/direct8.h"
#include "generic/generic.h"

#define DEVICE "/dev/fb"
#define ROMSIZE 0x00040000

/*
 *
 */

static int fh;

void sunPutCmap (COLORTABLE *colTab)
{
  struct fbcmap cm;

  cm.index = 0;
  cm.count = colTab->colors;
  cm.red = colTab->red;
  cm.green = colTab->green;
  cm.blue = colTab->blue;

  ioctl (fh, FBIOPUTCMAP, &cm);
}


/*
 *
 */

SCREEN sun_screen = {
  {}, sunPutCmap, NULL, direct8_mouseShow, direct8_mouseHide,
  direct8_plot, direct8_test, direct8_line, direct8_hline,
  direct8_vline, generic_box, generic_pbox, direct8_dvline,
  direct8_dhline, generic_dbox, generic_dpbox, generic_circ,
  generic_pcirc, generic_ellipse, generic_pellipse, direct8_bitblk,
  direct8_scroll, direct8_normalc, direct8_stylec, generic_prints,
  direct8_dplot, direct8_dline, generic_dcirc, generic_dpcirc,
  generic_dellipse, generic_dpellipse, generic_poly, generic_dpoly,
  generic_ppoly, generic_dppoly, generic_bezier, generic_dbezier,
  direct8_createbm
};


SCREEN *sun_init (void)
{
  int size;
  caddr_t addr;
  struct fbtype fb;

  if ((fh = open(DEVICE, O_RDWR)) < 0) {
    perror("open()");
    return NULL;
  }

  if (ioctl(fh, FBIOGTYPE, &fb)) {
    perror("ioctl()");
    return NULL;
  }

  switch (fb.fb_type) {
    case FBTYPE_SUN4COLOR:
      printf("Sun: Memory color w/overlay\n");
      break;
    default:
      fprintf(stderr, "Sun: Unknown graphics device, aborting\n");
      close(fh);
      return NULL;
  }

  printf("%i x %i pixels, %i bits per pixel\n",
	 fb.fb_width, fb.fb_height, fb.fb_depth);

  size = fb.fb_width * fb.fb_height;
  if ((addr = mmap(0, size,
		   PROT_READ | PROT_WRITE, MAP_SHARED,
		   fh, ROMSIZE)) == (caddr_t) -1) {
    perror("mmap()");
    close(fh);
    return NULL;
  }

  printf("%iK mapped to 0x%08x\n", size >> 10, (unsigned int)addr);

  sleep(2);

  sun_screen.bm.width = fb.fb_width;
  sun_screen.bm.height = fb.fb_height;
  sun_screen.bm.type = BM_DIRECT8;
  sun_screen.bm.unitsize = 1;
  sun_screen.bm.upl = fb.fb_width;
  sun_screen.bm.planes = 8;
  sun_screen.bm.data = addr;

  return &sun_screen;
}

#endif
