/*
 * server/graph/netbsd_amiga.c, part of W
 * (C) 94-07/96 TeSche (Torsten Scherer)
 * itschere@techfak.uni-bielefeld.de
 *
 * this file:
 * (C) 01/96-06/96 Phx (Frank Wille)
 * frank@phoenix.owl.de
 *
 * init code for NetBSD Amiga graphics devices
 *
 * CHANGES:
 * (02-Feb-96) Adapted for W1R2PL3
 * (08-Feb-96) Adapted for W1R3a (bm.wpl -> bm.upl)
 */

#ifdef __NetBSD__

#include <stdio.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#include <amiga/dev/grfioctl.h>
#include "../config.h"
#include "../types.h"
#include "gproto.h"
#include "direct8/direct8.h"
#include "generic/generic.h"


/*
 * Support for all Amiga graphics devices, except /dev/grf0 (=Amiga Custom
 * Chipset) and /dev/grf4 (=A2024 Monitor).
 * Currently tested for /dev/grf5 (Cybervision 64) only.
 */


static int fh;


static void grfPutCmap(COLORTABLE *colTab)
{
  struct grf_colormap cm;

  cm.index = 0;
  cm.count = colTab->colors;
  cm.red = colTab->red;
  cm.green = colTab->green;
  cm.blue = colTab->blue;

  ioctl(fh, GRFIOCPUTCMAP, &cm);
}


SCREEN netbsd_grf_screen[6] = {

  {{},NULL, NULL, NULL},

  {{}, grfPutCmap, NULL, direct8_mouseShow, direct8_mouseHide,
     direct8_plot, direct8_test, direct8_line, direct8_hline,
     direct8_vline, generic_box, generic_pbox, direct8_dvline,
     direct8_dhline, generic_dbox, generic_dpbox, generic_circ,
     generic_pcirc, direct8_bitblk, direct8_scroll, direct8_normalc,
     direct8_stylec, direct8_prints, direct8_dplot, direct8_dline,
     generic_dcirc, generic_dpcirc, generic_poly, generic_dpoly,
     generic_ppoly, generic_dppoly, direct8_createbm},

  {{}, grfPutCmap, NULL, direct8_mouseShow, direct8_mouseHide,
     direct8_plot, direct8_test, direct8_line, direct8_hline,
     direct8_vline, generic_box, generic_pbox, direct8_dvline,
     direct8_dhline, generic_dbox, generic_dpbox, generic_circ,
     generic_pcirc, direct8_bitblk, direct8_scroll, direct8_normalc,
     direct8_stylec, direct8_prints, direct8_dplot, direct8_dline,
     generic_dcirc, generic_dpcirc, generic_poly, generic_dpoly,
     generic_ppoly, generic_dppoly, direct8_createbm},

  {{}, grfPutCmap, NULL, direct8_mouseShow, direct8_mouseHide,
     direct8_plot, direct8_test, direct8_line, direct8_hline,
     direct8_vline, generic_box, generic_pbox, direct8_dvline,
     direct8_dhline, generic_dbox, generic_dpbox, generic_circ,
     generic_pcirc, direct8_bitblk, direct8_scroll, direct8_normalc,
     direct8_stylec, direct8_prints, direct8_dplot, direct8_dline,
     generic_dcirc, generic_dpcirc, generic_poly, generic_dpoly,
     generic_ppoly, generic_dppoly, direct8_createbm},

  {{}, NULL, NULL},

  {{}, grfPutCmap, NULL, direct8_mouseShow, direct8_mouseHide,
     direct8_plot, direct8_test, direct8_line, direct8_hline,
     direct8_vline, generic_box, generic_pbox, direct8_dvline,
     direct8_dhline, generic_dbox, generic_dpbox, generic_circ,
     generic_pcirc, generic_ellipse, generic_pellipse, direct8_bitblk,
     direct8_scroll, direct8_normalc, direct8_stylec, direct8_prints,
     direct8_dplot, direct8_dline, generic_dcirc, generic_dpcirc,
     generic_dellipse, generic_dpellipse, generic_poly, generic_dpoly,
     generic_ppoly, generic_dppoly, generic_bezier, generic_dbezier,
     direct8_createbm}, };


SCREEN *netbsd_amiga_init(void)
{
  size_t size;
  caddr_t addr;
  volatile int vmode = GRF_VMODE;
  struct grfvideo_mode gv;
  char grfdev[10];

  sprintf(grfdev, "/dev/grf%d", NETBSD_GRF);
  if (!netbsd_grf_screen[NETBSD_GRF].mouseShow) {
    fprintf(stderr, "%s not supported!\n", grfdev);
    return NULL;
  }

  if ((fh = open(grfdev, O_RDWR)) < 0) {
    perror("open()");
    return NULL;
  }

  /* Init graphics - set requested Video Mode */
  if (ioctl(fh, GRFSETVMODE, &vmode)) {
    perror("ioctl()");
    close(fh);
    return NULL;
  }
  ioctl(fh, GRFIOCON);
  gv.mode_num = vmode;
  ioctl(fh, GRFGETVMODE, &gv);

  printf("%d x %d pixels, %d bits per pixel\n",
	 gv.disp_width, gv.disp_height, gv.depth);

  size = (size_t)(gv.disp_width * gv.disp_height * gv.depth) >> 3;

  if ((addr = mmap(0, size,
		   PROT_READ | PROT_WRITE, MAP_SHARED,
		   fh, 65536)) == (caddr_t) -1) {
    perror("mmap()");
    close(fh);
    return NULL;
  }

  printf("%dK mapped to 0x%08x\n", size >> 10, (unsigned int)addr);

  netbsd_grf_screen[NETBSD_GRF].bm.width = gv.disp_width;
  netbsd_grf_screen[NETBSD_GRF].bm.height = gv.disp_height;
  netbsd_grf_screen[NETBSD_GRF].bm.type = BM_DIRECT8;
  netbsd_grf_screen[NETBSD_GRF].bm.unitsize = 1;
  netbsd_grf_screen[NETBSD_GRF].bm.upl = gv.disp_width;
  netbsd_grf_screen[NETBSD_GRF].bm.planes = gv.depth;  /* must be 8 */
  netbsd_grf_screen[NETBSD_GRF].bm.data = (ushort *)addr;

  return &netbsd_grf_screen[NETBSD_GRF];
}

#endif
