/*
 * server/graph/init.c, part of W
 * (C) 94-10/96 TeSche (Torsten Scherer)
 * itschere@techfak.uni-bielefeld.de
 *
 * top level function for graphic initialization
 *
 * CHANGES:
 * - added support for NetBSD-Amiga, Phx 02/96
 */

#include <stdio.h>
#include <string.h>
#include "../config.h"
#include "../types.h"
#include "gproto.h"
#include "generic/generic.h"

/*
 * exported global variables
 */

REC *clip0, *clip1;
GCONTEXT *gc0;

ushort BackGround[16] = {
  0xEEEE, 0xBBBB, 0xDDDD, 0x7777, 0xEEEE, 0xBBBB, 0xDDDD, 0x7777,
  0xEEEE, 0xBBBB, 0xDDDD, 0x7777, 0xEEEE, 0xBBBB, 0xDDDD, 0x7777
};
ushort DefaultPattern[16] = {
  0xAAAA, 0x5555, 0xAAAA, 0x5555, 0xAAAA, 0x5555, 0xAAAA, 0x5555,
  0xAAAA, 0x5555, 0xAAAA, 0x5555, 0xAAAA, 0x5555, 0xAAAA, 0x5555
};
/* other patterns? */

/* 
 * These are private to graphics library
 */

SCREEN *theScreen;		 /* same as glob_screen */

/*
 * a small bitmap / REC to do all e.g. clipping.
 */

#define TMP_W	64
#define TMP_H	100

REC clipTmp = { 0, 0, TMP_W, TMP_H, TMP_W - 1, TMP_H - 1, NULL};
BITMAP bitmapTmp;


/*
 *
 */

SCREEN *screen_init(int forceMono)
{
  /* root window pattern */
  static REC clip;
  static ushort pattern[16];
  static GCONTEXT gc = {M_DRAW, 0, NULL, pattern,
			  1, 0,
			  {0xffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0},
			  {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}};

#if defined(SVGALIB)
  theScreen = svgalib_init();
#elif defined(linux) || defined(__MINT__)
  theScreen = atari_init(forceMono);
#elif defined(sun)
  theScreen = sun_init();
#elif defined(__NetBSD__)
  theScreen = netbsd_amiga_init();
#endif

  if (theScreen) {
    if (!(*theScreen->createbm)(&bitmapTmp, TMP_W, TMP_H, 1))
      return NULL;
  }

  if (theScreen) {

    /* clear the memory first... */
    memset(theScreen->bm.data, 0,
	   theScreen->bm.upl * theScreen->bm.unitsize * theScreen->bm.height);

    clip.x0 = clip.y0 = 0;
    clip.x1 = (clip.w = theScreen->bm.width) - 1;
    clip.y1 = (clip.h = theScreen->bm.height) - 1;

    gc0 = &gc;
    clip0 = &clip;
    memcpy(pattern, BackGround, sizeof(pattern));
    /* ...and then draw the pattern (invert is the default mode). */
    generic_dpbox (&theScreen->bm, 0, 0, theScreen->bm.width, theScreen->bm.height);
  }

  /* return whatever we've got */
  return theScreen;
}
