/*
 * generic/prints.c, part of W
 * (C) 94-04/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * generic string output routines using driver specific character routines.
 *
 * Changes:
 *
 * - Split TeSche's and Kay's text.c code into generic and driver
 *   specific parts and moved clipping to prints.
 * - Implemented underline with hline() and prepared for font references.
 *   ++eero 11/96
 *
 * TODO:
 * - Add font references to W server.  Modify the string and character
 *   printing functions accordingly (see comments packed/text.c and prints
 *   functions).
 */

#include <stdio.h>
#include "../../config.h"
#include "../../types.h"
#include "../gproto.h"
#include "generic.h"

/* baseline should be the lowest line of set pixels on alphanumeric
 * characters (other than [qypj]). Value below will leave one (empty)
 * pixel line between baseline and underline.
 */
#define UNDERLINE_OFFSET	2


/* Clip a character.  Mainly used for italics at window sides, although due
 * bitblk rectangle overlap the character at the right border will then
 * clear some pixels off the previous character.  With other styles the
 * rectangles won't overlap.
 */
static void clipchar(destbm, x0, y0, width, height, c, effects)
     BITMAP *destbm;
     long x0;
     long y0;
     short width;
     short height;
     uchar c;
     ushort effects;
{
  REC *save_clip1;

  if (effects & F_ITALIC) {
    width += gc0->font->hdr.slant_size;	/* gc0->fref.font->hdr.slant_size */
  }

  if (width > bitmapTmp.width || height > bitmapTmp.height) {
    return;
  }

  if (effects & ~F_UNDERLINE) {
    theScreen->stylec(&bitmapTmp, 0, 0, c);
  } else {
    theScreen->normalc(&bitmapTmp, 0, 0, c);
  }

  save_clip1 = clip1;
  clip1 = clip0;
  clip0 = &clipTmp;
  (*theScreen->bitblk)(&bitmapTmp, 0, 0, width, height, destbm, x0, y0);
  clip0 = clip1;
  clip1 = save_clip1;
}


void generic_prints(bm, x0, y0, s)
     BITMAP *bm;
     long x0;
     long y0;
     uchar *s;
{
  FONT  *font = gc0->font;			/* gc0->fref.font */
  short effects = gc0->textstyle;		/* gc0->fref.effects */
  uchar *widths = font->widths;
  short height = font->hdr.height;
  short ul_x, ul_w, width = 0, count = 0;
  uchar *end;


#if 1
  /* settextstyle:
   * fref->effects =
   *   fref->font->effects | (new_effects & fref->font->hdr.effect_mask);
   * where:
   * - `effects' is a mask for indicating what styles should be emulated.
   *   It is set when font is loaded (in W or font server).
   * - `effect_mask' is a mask from font file header for readable style
   *   effects.  It is also used for masking font loading style requests.
   *   (what styles font server generates if there's no readymade font)
   * - 'new_effects' is argument to the settextstyle function.
   */
  font->effects = effects;
#endif


  /* string lenght & width */
  end = s;
  while (*end) {
    width += widths[*end++];
    count++;
  }

  /* for underline */
  ul_w = width;
  ul_x = x0;

  /* italic correction */
  if (effects & F_ITALIC) {
    x0 -= font->hdr.slant_offset;
    width += font->hdr.slant_size;
  }

  /* 
   * Clip necessary chars
   */
  if (clip0) {

    /* find the rightmost visible char and clip it if necessary */
    while ((x0 + width - 1) > clip0->x1 && count) {
      end--;
      count--;
      width -= widths[*end];
      if ((x0 + width - 1) <= clip0->x1) {
        if (effects & F_ITALIC) {
	  clipchar(bm, x0 + width - font->hdr.slant_size, y0, widths[*end], height, *end, effects);
	} else {
	  clipchar(bm, x0 + width, y0, widths[*end], height, *end, effects);
	}
      }
    }

    /* find the leftmost visible char and clip it if necessary */
    while(x0 < clip0->x0 && count) {
      x0 += widths[*s];
      if (x0 >= clip0->x0) {
	clipchar(bm, x0 - widths[*s], y0, widths[*s], height, *s, effects);
      }
      count--;
      s++;
    }
    if (count < 1) {
      goto bottomline;
    }

    /* clip rest of the chars in vertical direction if necessary */
    if (y0 < clip0->y0 || (y0 + height - 1) > clip0->y1) {
      if (y0 > clip0->y1 || (y0 + height - 1) < clip0->y0) {
        return;
      }
      while (count--) {
	clipchar(bm, x0, y0, widths[*s], height, *s, effects);
	x0 += widths[*s++];
      }
      goto bottomline;
    }
  }


  /*
   * rest of the string doesn't need clipping...
   */

  if (effects & ~F_UNDERLINE) {
    while (count--) {
      theScreen->stylec(bm, x0, y0, *s);
      x0 += widths[*s++];
    }
  } else {
    while (count--) {
      theScreen->normalc(bm, x0, y0, *s);
      x0 += widths[*s++];
    }
  }


bottomline:

  if (effects & F_UNDERLINE) {
    short old_mode = gc0->drawmode;

    if ((effects | font->hdr.styles) & F_REVERSE) {
      gc0->drawmode = M_CLEAR;
    } else {
      gc0->drawmode = M_DRAW;
    }
    if(font->hdr.baseline + UNDERLINE_OFFSET < font->hdr.height) {
      y0 += font->hdr.baseline + UNDERLINE_OFFSET;
    } else {
      y0 += font->hdr.height - 1;
    }
    (*theScreen->hline)(bm, ul_x, y0, ul_x + ul_w - 1);
    gc0->drawmode = old_mode;
  }
}
