/*
 * server/graph/generic/generic_box.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * routines dealing with boxes
 *
 * CHANGES:
 *
 * - added proper patterned versions of box and pbox. ++eero, 1/96
 * - changed eero's pbox optimizations into something more portable and
 *   equally fast. ++kay, 1/96
 * - added comments on how to speed up things. ++kay, 1/96
 * - bug fixed and clipping optimized in (d)pbox(), TeSche 01/96
 */

#include <stdio.h>
#include "../../config.h"
#include "../../types.h"
#include "../gproto.h"
#include "../clip.h"
#include "generic.h"


/*
 *
 */

void generic_box (bm, x0, y0, width, height)
     register BITMAP *bm;
     register long x0;
     register long y0;
     register long width;
     register long height;
{
  if (!width || !height) {
    return;
  }

  if (height == 1) {
    (*theScreen->hline) (bm, x0, y0, x0+width-1);
    return;
  }

  if (width == 1) {
    (*theScreen->vline) (bm, x0, y0, y0+height-1);
    return;
  }

  (*theScreen->hline) (bm, x0, y0, x0+width-2);
  (*theScreen->vline) (bm, x0+width-1, y0, y0+height-2);
  (*theScreen->hline) (bm, x0+width-1, y0+height-1, x0+1);
  (*theScreen->vline) (bm, x0, y0+height-1, y0+1);
}


void generic_pbox (bm, x0, y0, width, height)
     register BITMAP *bm;
     register long x0;
     register long y0;
     register long width;
     register long height;
{
  register void (*line_fn) (BITMAP *, long, long, long);
  REC *oclip = clip0;

  if (!width || !height) {
    return;
  }

  if (height == 1) {
    (*theScreen->hline) (bm, x0, y0, x0+width-1);
    return;
  }

  if (width == 1) {
    (*theScreen->vline) (bm, x0, y0, y0+height-1);
    return;
  }

  if (CLIP_BOX (x0, y0, width, height, clip0)) {
    return;
  }

  /* now tell vline/hline not to perform clipping, we did it already
   * ourself.
   */
  clip0 = NULL;

  if (2*width >= height) {
    line_fn = theScreen->hline;
    width = x0 + width - 1;	/* the other endpoint */
    while (--height >= 0)
      (*line_fn) (bm, x0, y0++, width);
  } else {
    line_fn = theScreen->vline;
    height = y0 + height - 1;
    while (--width >= 0)
      (*line_fn) (bm, x0++, y0, height);
  }
  clip0 = oclip;
}


/*
 * patterned versions
 */

void generic_dbox (bm, x0, y0, width, height)
     register BITMAP *bm;
     register long x0;
     register long y0;
     register long width;
     register long height;
{
  if (!width || !height)
    return;

  if (height == 1) {
    (*theScreen->dhline) (bm, x0, y0, x0 + width - 1);
    return;
  }

  if (width == 1) {
    (*theScreen->dvline) (bm, x0, y0, y0 + height - 1);
    return;
  }

  (*theScreen->dhline) (bm, x0, y0, x0 + width - 2);
  (*theScreen->dvline) (bm, x0 + width - 1, y0, y0 + height - 2);
  (*theScreen->dhline) (bm, x0 + width - 1, y0 + height - 1, x0 + 1);
  (*theScreen->dvline) (bm, x0, y0 + height - 1, y0 + 1);
}


void generic_dpbox (bm, x0, y0, width, height)
     register BITMAP *bm;
     register long x0;
     register long y0;
     register long width;
     register long height;
{
  register void (*dline_fn) (BITMAP *, long, long, long);
  REC *oclip = clip0;

  if (!width || !height)
    return;

  if (height == 1) {
    (*theScreen->dhline) (bm, x0, y0, x0 + width - 1);
    return;
  }

  if (width == 1) {
    (*theScreen->dvline) (bm, x0, y0, y0 + height - 1);
    return;
  }

  if (CLIP_BOX (x0, y0, width, height, clip0)) {
    return;
  }

  /* now tell vline/hline not to perform clipping, we did it already
   * ourself.
   */
  clip0 = NULL;

  /*
   * hlines's are about twice as fast as vlines.
   */
  if (2*width >= height) {
    dline_fn = theScreen->dhline;
    width = x0 + width - 1;	/* the other endpoint */
    while (--height >= 0)
      (*dline_fn) (bm, x0, y0++, width);
  } else {
    dline_fn = theScreen->dvline;
    height = y0 + height - 1;
    while (--width >= 0)
      (*dline_fn) (bm, x0++, y0, height);
  }
  clip0 = oclip;
}
