/*
 * server/config.h, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#ifndef __W_CONFIG_H
#define __W_CONFIG_H

/* default font offered for clients */
#define WFONT_EXTENSION	"wfnt"
#define DEF_WFONTFAMILY	"fixed"
#define DEF_WFONTSIZE	10

/* fonts that server uses itself */
#define DEF_WTITLEFONT	"fixed8.wfnt"
#define DEF_WMENUFONT	"lucidat11.wfnt"


/* some configuration options */
#if 1
#undef CHILDS_INSIDE_PARENTS
#undef REFRESH
#undef AF_UNIX_ONLY
#else /* for testing purposes... */
#define CHILDS_INSIDE_PARENTS
#define REFRESH
#define AF_UNIX_ONLY
#endif

/* this doesn't yet work */
#undef LAZYMOUSE

#define	SERVERPORT 7777

#define MAX_LINELEN 256		/* max. config file line lenght */
#define MAXFAMILYNAME 16	/* font family name lenght, divisable by 4 */
#define MAXPOLYPOINTS 64	/* max. w_poly() points, divisable with 2 */
#define MAXPRINTS 64		/* printstring packet string size, -"- */
#define MAXTITLE 64		/* max. window title packet string lenght */

/* some graphic options */

#define MAXFONTS 32		/* max. number of fonts loaded at same time */
#define MAXCLIENTFONTS 8	/* -"- per client */
#define MAXITEMS 16		/* max. number of root menu items */


/* some network options */

#define MAXLISTENQUEUE 4
#define UNIXNAME "/tmp/wserver"


/* do _not_ change any of these! */

#define	BUTTON_ALL	7
#define	BUTTON_LEFT	4
#define	BUTTON_MID	2
#define	BUTTON_RIGHT	1
#define	BUTTON_NONE	0

/* client socket input buffer size (> largest packet) in loop.c */
#define	LARGEBUF	2048

#endif /* __W_CONFIG_H */
