/*
 * server/client_others.c, part of W
 * (C) 1994,95,96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * these are other functions. in fact they're only *here* to
 * keep the source somehow structured and small for each part
 *
 * not very much in it so far, eh? :)
 *
 * I added ellipse and bezier functions here because client_noret.c is
 * so big. You can move them where you'll want them to be ++eero 10/96
 *
 * FIXME: I'll do
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#ifdef __MINT__
# include <mintbind.h>
#endif

#include "config.h"
#include "types.h"
#include "pakets.h"
#include "proto.h"
#include "window.h"
#include "rect.h"	/* for ellipse/bezier */


/*
 *
 */

short client_status(CLIENT *cptr, CLIENT *clients, short index, STATUS *status)
{
  short i;
  CLIENT *ptr;

  if (index < 0) {

    i = 0;
    ptr = clients;
    while (ptr) {
      i++;
      ptr = ptr->next;
    }

    status->ip_addr = ntohl(0);
    status->pakets = ntohl(glob_pakets);
    status->bytes = ntohl(glob_bytes);
    status->openWin = ntohs(globOpenWindows);
    status->totalWin = ntohs(globTotalWindows);

    return i;
  }

  /* try to get a specific client */

  ptr = clients;
  while (ptr && (index-- > 0)) {
    ptr = ptr->next;
  }

  if (!ptr) {
    return -1;
  }

  status->ip_addr = ntohl(ptr->raddr);
  status->pakets = ntohl(ptr->pakets);
  status->bytes = ntohl(ptr->bytes);
  status->openWin = ntohs(ptr->openWindows);
  status->totalWin = ntohs(ptr->totalWindows);

  return 0;
}


void client_ellipse(CLIENT *cptr, ushort handle, short x0, short y0, short rx, short ry)
{
  WINDOW *win;
  void (*ell)(BITMAP *, long, long, long, long);
  long sizex = (rx << 1) + 1;
  long sizey = (ry << 1) + 1;

  if (rx < 0 || ry < 0) {
    return;
  }

  if (!(win = windowLookup(handle))) {
    return;
  }

  if (win->flags & W_CONTAINER) {
    return;
  }

  switch (glob_pakettype) {
    case PAK_ELLIPSE:
      ell = glob_screen->ell;
      break;
    case PAK_PELLIPSE:
      ell = glob_screen->pell;
      break;
    case PAK_DELLIPSE:
      ell = glob_screen->dell;
      break;
    default:   /* PAK_DPellipse */
      ell = glob_screen->dpell;
  }

  x0 += win->area[AREA_WORK].x0;
  y0 += win->area[AREA_WORK].y0;
  gc0 = &win->gc;

#ifndef REFRESH
  if (win->is_open && !win->is_hidden) {
    if (mouse_rcintersect(win->pos.x0+x0-rx,
			  win->pos.y0+y0-ry, sizex, sizey)) {
      mouse_hide();
    }
    clip0 = &win->work;
    (*ell)(&glob_screen->bm, win->pos.x0 + x0,
	    win->pos.y0 + y0, rx, ry);
    win->is_dirty = 1;
  } else
#endif
  {
    clip0 = &win->area[AREA_WORK];
    (*ell)(&win->bitmap, x0, y0, rx, ry);
    if (win->is_open) {
      if (mouse_rcintersect(win->pos.x0+x0-rx,
			    win->pos.y0+y0-ry, sizex, sizey)) {
	mouse_hide();
      }
      rectUpdateDirty(&win->dirty, x0-rx, y0-ry, sizex, sizey);
    }
  }
}


void client_bezier(CLIENT *cptr, ushort handle, short *controls)
{
  static long lpoints[8];
  long *lptr = lpoints;
  short x, y, xmin, ymin, xmax, ymax, wx0, wy0, count = 4;
  WINDOW *win;
  void (*bez)(BITMAP *, long *);

  if (!(win = windowLookup(handle))) {
    return;
  }

  if (win->flags & W_CONTAINER) {
    return;
  }

  if (glob_pakettype == PAK_BEZIER) {
    bez = glob_screen->bez;
  } else {
    bez = glob_screen->dbez;
  }

  wx0 = win->area[AREA_WORK].x0;
  wy0 = win->area[AREA_WORK].y0;
  xmin = 32767;
  ymin = 32767;
  xmax = -32768;
  ymax = -32768;

  gc0 = &win->gc;

#ifndef REFRESH
  if (win->is_open && !win->is_hidden) {
    wx0 += win->pos.x0;
    wy0 += win->pos.y0;
    /* max. extent for bezier */
    while (count--) {
      /*
       * ntohs evaluates it's argument more than once
       */
      x = *controls++;
      y = *controls++;
      if ((x = ntohs (x)) < xmin) xmin = x;
      if (x > xmax) xmax = x;
      if ((y = ntohs (y)) < ymin) ymin = y;
      if (y > ymax) ymax = y;
      *lptr++ = x + wx0;
      *lptr++ = y + wy0;
    }
    xmax = xmax - xmin + 1;   /* this really is 'width' */
    ymax = ymax - ymin + 1;
    if (mouse_rcintersect(wx0 + xmin, wy0 + ymin, xmax, ymax)) {
      mouse_hide();
    }
    clip0 = &win->work;
    (*bez)(&glob_screen->bm, lpoints);
    win->is_dirty = 1;
  } else
#endif
  {
    /* max. extent for bezier */
    while (count--) {
      x = *controls++;
      y = *controls++;
      if ((x = ntohs(x)) < xmin) xmin = x;
      if (x > xmax) xmax = x;
      if ((y = ntohs(y)) < ymin) ymin = y;
      if (y > ymax) ymax = y;
      *lptr++ = x + wx0;
      *lptr++ = y + wy0;
    }
    xmax = xmax - xmin + 1;   /* this really is 'width' */
    ymax = ymax - ymin + 1;
    clip0 = &win->area[AREA_WORK];
    (*bez)(&win->bitmap, lpoints);
    if (win->is_open) {
      if (mouse_rcintersect(win->work.x0 + xmin,
			    win->work.y0 + ymin, xmax, ymax)) {
	mouse_hide();
      }
      rectUpdateDirty(&win->dirty, wx0 + xmin, wy0 + ymin, xmax, ymax);
    }
  }
}
