/*
 * lib/window.c, part of Wlib, part of W
 * (C) 1994,95,96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Wlib.h"
#include "proto.h"


WWIN *w_create (short width, short height, short flags)
{
  WWIN *ptr;
  CREATEP paket;
  ushort ret;

  TRACESTART();

  if (!(ptr = calloc (1, sizeof (WWIN)))) {
    TRACEPRINT(("w_create(%i,%i,0x%04x) -> NULL\n",\
		width, height, (unsigned int)flags));
    TRACEEND();
    return NULL;
  }

  paket.len = sizeof(CREATEP);
  paket.type = PAK_CREATE;
  paket.width = htons(width);
  paket.height = htons(height);
  paket.flags = htons(flags);
  paket.libPtr = ptr;
  _send_paket((PAKET *)&paket);

  if (!(ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret))) {
    free(ptr);
    TRACEPRINT(("w_create(%i,%i,0x%04x) -> NULL\n",\
		width, height, (unsigned int)flags));
    TRACEEND();

    return NULL;
  }

  ptr->magic = MAGIC_W;
  ptr->handle = ret;
  ptr->width = width;
  ptr->height = height;
  ptr->drawmode = M_INVERS;
  ptr->pattern = GRAY_PATTERN;
  ptr->font = NULL;

  TRACEPRINT(("w_create(%i,%i,0x%04x) -> %p\n",\
	      width, height, (unsigned int)flags, ptr));
  TRACEEND();

  return ptr;
}


WWIN *w_createChild(WWIN *parent, short width, short height, short flags)
{
  WWIN *ptr;
  CREATEP paket;
  ushort ret;
  char *cptr;

  TRACESTART();

  if ((cptr = _check_window(parent))) {
    TRACEPRINT(("w_createChild(%p,%i,%i,0x%04x) -> NULL\n",\
		parent, width, height, (unsigned int)flags));
    TRACEEND();
    return NULL;
  }

  if (!(ptr = calloc(1, sizeof(WWIN)))) {
    TRACEPRINT(("w_createChild(%p,%i,%i,0x%04x) -> NULL\n",\
		parent, width, height, (unsigned int)flags));
    TRACEEND();
    return NULL;
  }

  paket.len = sizeof(CREATEP);
  paket.type = PAK_CREATE2;
  paket.width = htons(width);
  paket.height = htons(height);
  paket.flags = htons(flags);
  paket.handle = htons(parent->handle);
  paket.libPtr = ptr;
  _send_paket((PAKET *)&paket);

  if (!(ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret))) {
    free(ptr);
    TRACEPRINT(("w_createChild(%p,%i,%i,0x%04x) -> NULL\n",\
		parent, width, height, (unsigned int)flags));
    TRACEEND();

    return NULL;
  }

  ptr->magic = MAGIC_W;
  ptr->handle = ret;
  ptr->width = width;
  ptr->height = height;
  ptr->drawmode = M_INVERS;
  ptr->pattern = 0xaaaa;
  ptr->font = NULL;
  ptr->type = WWIN_SUB;

  TRACEPRINT(("w_createChild(%p,%i,%i,0x%04x) -> %p\n",\
	      parent, width, height, (unsigned int)flags, ptr));
  TRACEEND();

  return ptr;
}


short w_settitle(WWIN *win, char *s)
{
  char *cptr;
  STITLEP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_settitle(%p,%s) -> %s\n", win, s, cptr));
    TRACEEND();
    return -1;
  }

  TRACEPRINT(("w_settitle(%p,%s)\n", win, s));

  paket.len = sizeof(STITLEP);
  paket.type = PAK_STITLE;
  paket.handle = htons(win->handle);
  strncpy(paket.title, s, sizeof(paket.title)-1);
  paket.title[sizeof(paket.title)-1] = 0;
  _send_paket((PAKET *)&paket);

  TRACEEND();

  return 0;
}


short w_open(WWIN *win, short x0, short y0)
{
  char *cptr;
  OPENP paket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_open(%p,%i,%i) -> %s\n", win, x0, y0, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(OPENP);
  paket.type = PAK_OPEN;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  _send_paket((PAKET *)&paket);

  ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_open(%p,%i,%i) -> %i\n", win, x0, y0, ret));

  TRACEEND();

  return ret;
}


short w_move(WWIN *win, short x0, short y0)
{
  char *cptr;
  MOVEP paket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_move(%p,%i,%i) -> %s\n", win, x0, y0, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(MOVEP);
  paket.type = PAK_MOVE;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  _send_paket((PAKET *)&paket);

  ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_move(%p,%i,%i) -> %i\n", win, x0, y0, ret));
  TRACEEND();

  return ret;
}


short w_resize (WWIN *win, short width, short height)
{
  char *cptr;
  RESIZEP paket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_resize(%p,%i,%i) -> %s\n", win, width, height, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(RESIZEP);
  paket.type = PAK_RESIZE;
  paket.handle = htons(win->handle);
  paket.width = htons(width);
  paket.height = htons(height);
  _send_paket((PAKET *)&paket);

  ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_resize(%p,%i,%i) -> %i\n", win, width, height, ret));
  TRACEEND();

  return ret;
}


short w_close(WWIN *win)
{
  char *cptr;
  CLOSEP	paket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_close(%p) -> %s\n", win, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(CLOSEP);
  paket.type = PAK_CLOSE;
  paket.handle = htons(win->handle);
  _send_paket((PAKET *)&paket);

  ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_close(%p) -> %i\n", win, ret));
  TRACEEND();

  return ret;
}


short w_delete(WWIN *win)
{
  DELETEP paket;
  short ret;

  TRACESTART();

  paket.len = sizeof(DELETEP);
  paket.type = PAK_DELETE;
  paket.handle = htons(win->handle);
  _send_paket((PAKET *)&paket);

  if (!(ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret))) {

    _remove_events(win);
    win->magic = 0;
    free(win);
    TRACEPRINT(("w_delete(%p)\n", win));
    TRACEEND();

    return 0;
  }

  TRACEPRINT(("w_delete(%p) -> %i\n", win, ret));
  TRACEEND();

  return ret;
}
