/*
 * lib/proto.h, part of W
 * (C) 94-07/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#ifndef __W_PROTO_H
#define __W_PROTO_H

#include <stdio.h>
#include <sys/time.h>
#include <netinet/in.h>
#include "../server/config.h"
#include "../server/pakets.h"

#ifdef TRACE
#define TRACESTART() { _traceIndent += 2; }
#define TRACEPRINT(args) if (_trace) { _spaces(_traceIndent-2); printf args ; fflush(stdout); }
#define TRACEEND() { _traceIndent -= 2; }
#else
#define TRACESTART()
#define TRACEPRINT(args)
#define TRACEEND()
#endif


extern long _initialize (void);
extern void _send_paket (PAKET *pptr);
extern PAKET *_wait4paket (short type);
extern WEVENT *_wait4event (fd_set *rfd, fd_set *wfd, fd_set *xfd,
			    long timeout, int *numReady);
extern char *_check_window (WWIN *ptr);
extern void _wexit(void);
extern int _trace;
extern int _traceIndent;
extern void _spaces (int arg);
extern void _remove_events (WWIN *win);
extern WSERVER _wserver;

#endif /* __W_PROTO */
