/*
 * lib/poly.c, part of W
 * (C) 94-03/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <stddef.h>
#include "Wlib.h"
#include "proto.h"


static inline short poly(WWIN *win, short numpoints, short *points,
			 short type, char *fname)
{
  char *cptr;
  POLYP paket;
  long i;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("%s(%p,%i,%p) -> %s\n", fname, win, numpoints, points, cptr));
    TRACEEND();
    return -1;
  }

  if (numpoints > MAXPOLYPOINTS) {
    TRACEPRINT(("%s(%p,%i,%p) -> too many points\n",\
		fname, win, numpoints, points));
    TRACEEND();
    return -1;
  }

  if (numpoints < 3) {
    TRACEPRINT(("%s(%p,%i,%p) -> too few points\n",\
		fname, win, numpoints, points));
    TRACEEND();
    return -1;
  }

  paket.numpoints = htons(numpoints);
  numpoints <<= 1;
  for (i=0; i<numpoints; i++) {
    paket.points[i] = htons(*points);
    ++points;
  }
  paket.len = offsetof(POLYP, points) + (numpoints << 1);
  paket.type = type;
  paket.handle = htons(win->handle);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("%s(%p,%i,%p)\n",\
	      fname, win, numpoints, points));

  TRACEEND();
  return 0;
}


short w_poly(WWIN *win, short numpoints, short *points)
{
  return poly(win, numpoints, points, PAK_POLY, "w_poly");
}


short w_ppoly(WWIN *win, short numpoints, short *points)
{
  return poly(win, numpoints, points, PAK_PPOLY, "w_ppoly");
}


short w_dpoly(WWIN *win, short numpoints, short *points)
{
  return poly(win, numpoints, points, PAK_DPOLY, "w_dpoly");
}


short w_dppoly(WWIN *win, short numpoints, short *points)
{
  return poly(win, numpoints, points, PAK_DPPOLY, "w_dppoly");
}
