/*
 * lib/plot.c, part of W
 * (C) 94-03/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include "Wlib.h"
#include "proto.h"


static inline short plot(WWIN *win, short x0, short y0,
			 short type, char *fname)
{
  char *cptr;
  PLOTP	paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("%s(%p,%i,%i) -> %s\n", fname, win, x0, y0, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(PLOTP);
  paket.type = type;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("%s(%p,%i,%i)\n", fname, win, x0, y0));
  TRACEEND();

  return 0;
}

short w_plot(WWIN *win, short x0, short y0)
{
  return plot(win, x0, y0, PAK_PLOT, "w_plot");
}


short w_dplot(WWIN *win, short x0, short y0)
{
  return plot(win, x0, y0, PAK_DPLOT, "w_dplot");
}


short w_test(WWIN *win, short x0, short y0)
{
  char *cptr;
  TESTP	paket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_test(%p,%i %i) -> %s\n", win, x0, y0, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(TESTP);
  paket.type = PAK_TEST;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  _send_paket((PAKET *)&paket);

  ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_test(%p,%i %i) -> %i\n", win, x0, y0, ret));
  TRACEEND();

  return ret;
}
