/*
 * lib/line.c, part of W
 * (C) 94-04/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include "Wlib.h"
#include "proto.h"


/*
 * fast lines
 */

static inline short hvline(WWIN *win, short x0, short y0, short e,
			   short type, char *fname)
{
  char *cptr;
  HVLINEP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("%s(%p,%i,%i,%i) -> %s\n", fname, win, x0, y0, e, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(HVLINEP);
  paket.type = type;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.e = htons(e);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("%s(%p,%i,%i,%i)\n", fname, win, x0, y0, e));
  TRACEEND();

  return 0;
}


short w_hline(WWIN *win, short x0, short y0, short xe)
{
  return hvline(win, x0, y0, xe, PAK_HLINE, "w_hline");
}


short w_vline(WWIN *win, short x0, short y0, short ye)
{
  return hvline(win, x0, y0, ye, PAK_VLINE, "w_vline");
}


short w_dhline(WWIN *win, short x0, short y0, short xe)
{
  return hvline(win, x0, y0, xe, PAK_DHLINE, "w_dhline");
}


short w_dvline(WWIN *win, short x0, short y0, short ye)
{
  return hvline(win, x0, y0, ye, PAK_DVLINE, "w_dvline");
}


/*
 * normal lines
 */

static short line(WWIN *win, short x0, short y0, short xe, short ye, short type, char *fname)
{
  char *cptr;
  LINEP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("%s(%p,%i,%i,%i,%i) -> %s\n", fname, win, x0, y0, xe, ye, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(LINEP);
  paket.type = type;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.xe = htons(xe);
  paket.ye = htons(ye);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("%s(%p,%i,%i,%i,%i)\n", fname, win, x0, y0, xe, ye));
  TRACEEND();

  return 0;
}


short w_line(WWIN *win, short x0, short y0, short xe, short ye)
{
  return line(win, x0, y0, xe, ye, PAK_LINE, "w_line");
}


short w_dline(WWIN *win, short x0, short y0, short xe, short ye)
{
  return line(win, x0, y0, xe, ye, PAK_DLINE, "w_dline");
}
