/*
 * lib/init.c, part of Wlib, part of W
 * (C) 94-07/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "Wlib.h"
#include "proto.h"


WSERVER *w_init(void)
{
  INITP paket;
  INITRETP *irpaket;
  static WWIN wroot = { MAGIC_W, 0, -1, -1, M_DRAW, 0xAAAA, F_NORMAL, NULL };

  TRACESTART();

  if (_initialize() < 0) {
    TRACEPRINT(("w_init() -> NULL\n"));
    TRACEEND();
    return NULL;
  }

  paket.len = sizeof(INITP);
  paket.type = PAK_INIT;
  paket.uid = htons(getuid());
  _send_paket((PAKET *)&paket);

  irpaket = (INITRETP *)_wait4paket(PAK_INITRET);

  _wserver.vmaj = htons(irpaket->vmaj);
  _wserver.vmin = htons(irpaket->vmin);
  _wserver.pl = htons(irpaket->pl);
  _wserver.type = htons(irpaket->screenType);
  _wserver.width = htons(irpaket->width);
  _wserver.height = htons(irpaket->height);
  _wserver.planes = htons(irpaket->planes);
  _wserver.flags = htons(irpaket->flags);
  _wserver.fsize = htons(irpaket->fsize);
  _wserver.fname = strdup(irpaket->fname);

  if ((_wserver.vmaj != _WMAJ) || (_wserver.vmin != _WMIN)) {
    fprintf(stderr, "Wlib: this binary was compiled for W%iR%i, but\n",
	    _WMAJ, _WMIN);
    fprintf(stderr, "      the server claims to be W%iR%i, update your binary!\n",
	    _wserver.vmaj, _wserver.vmin);
    exit(-99);
  }

  TRACEPRINT(("w_init() -> %p\n", irpaket));

  wroot.width = _wserver.width;
  wroot.height = _wserver.height;
  wroot.font = NULL;
  WROOT = &wroot;

  TRACEEND();
  return &_wserver;
}


void w_exit(void)
{
  EXITP	expaket;

  TRACESTART();
  TRACEPRINT(("w_exit()\n"));

  expaket.len = sizeof(EXITP);
  expaket.type = PAK_EXIT;
  _send_paket((PAKET *)&expaket);

  /* this is needed for programs which run other W programs */
  _wexit();

  TRACEEND();
}


short w_null(void)
{
  INITP paket;

  TRACESTART();
  TRACEPRINT(("w_null()\n"));

  paket.len = 4;
  paket.type = PAK_NULL;
  _send_paket((PAKET *)&paket);

  TRACEEND();

  return 0;
}


short w_beep(void)
{
  short paket[2];

  TRACESTART();
  TRACEPRINT(("w_beep()\n"));

  paket[0] = 4;
  paket[1] = PAK_BEEP;
  _send_paket((PAKET *)paket);

  TRACEEND();

  return 0;
}


void w_trace(short flag)
{
#ifdef TRACE
  _trace = !!flag;

  TRACESTART();
  TRACEPRINT(("w_trace(%i)\n", flag));
  TRACEEND();
#else
  fprintf(stderr, "w_trace: tracing not implemented\n");
#endif
}

void _spaces(int arg)
{
  while (arg-- > 0)
    fputc(' ', stdout);
}
