/*
 * lib/geometry.c, part of Wlib, part of W
 * (C) 94-03/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * how to scan a geometry argument?
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "Wlib.h"
#include "proto.h"


void scan_geometry(char *geometry, short *col, short *lin,
		   short *xp, short *yp)
{
  TRACESTART();

  TRACEPRINT(("scan_geometry(%s,%p,%p,%p,%p)\n",\
	      geometry, col, lin, xp, yp));

  if (col)
    *col = UNDEF;
  if (lin)
    *lin = UNDEF;
  if (xp)
    *xp = UNDEF;
  if (yp)
    *yp = UNDEF;

  if (!geometry) {
    TRACEEND();
    return;
  }

  if (col)
    *col = atoi(geometry);

  if (!(geometry = strchr(geometry, ','))) {
    TRACEEND();
    return;
  }

  if (lin)
    *lin = atoi(++geometry);
  else
    geometry++;

  if (!(geometry = strchr(geometry, ','))) {
    TRACEEND();
    return;
  }

  if (xp) {
    *xp = atoi(++geometry);
    if (*geometry == '-') {
      *xp -= 1;
    }
  }
  else
    geometry++;

  if (!(geometry = strchr(geometry, ','))) {
    TRACEEND();
    return;
  }

  if (yp) {
    *yp = atoi(++geometry);
    if (*geometry == '-') {
      *yp -= 1;
    }
  }

  TRACEEND();
}

void limit2screen(WWIN *win, short *xp, short *yp)
{
  short ew, eh;
  char *cptr;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("limit2screen(%p,%p,%p) -> %s\n",\
		win, xp, yp, cptr));
    TRACEEND();
    return;
  }

  if (!xp || !yp) {
    TRACEPRINT(("limit2screen(%p,%p,%p) -> argument error\n",\
		win, xp, yp));
    TRACEEND();
    return;
  }

  w_querywinsize(win, 1, &ew, &eh);

  if ((*xp != UNDEF) && (*yp != UNDEF)) {
    if (*xp < 0) {
      *xp = _wserver.width - ew - *xp;
    }
    if (*yp < 0) {
      *yp = _wserver.height - eh - *yp;
    }
  } else {
    *xp = UNDEF;
    *yp = UNDEF;
  }

  TRACEPRINT(("limit2screen(%p,%p,%p) -> (%d,%d)\n",\
	      win, xp, yp, *xp, *yp));

  TRACEEND();
}
