/*
 * lib/ellipse.c, part of W
 * (C) 94-04/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * (w) by Eero Tamminen 10/96
 */

#include <stdio.h>
#include "Wlib.h"
#include "proto.h"


static inline short ellipse(WWIN *win, short x0, short y0, short rx, short ry,
			   short type, char *fname)
{
  char *cptr;
  ELLIPSEP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("%s(%p,%i,%i,%i,%i) -> %s\n", fname, win, x0, y0, rx, ry, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(ELLIPSEP);
  paket.type = type;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.rx = htons(rx);
  paket.ry = htons(ry);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("%s(%p,%i,%i,%i,%i)\n", fname, win, x0, y0, rx, ry));
  TRACEEND();

  return 0;
}


short w_ellipse(WWIN *win, short x0, short y0, short rx, short ry)
{
  return ellipse(win, x0, y0, rx, ry, PAK_ELLIPSE, "w_ellipse");
}


short w_pellipse(WWIN *win, short x0, short y0, short rx, short ry)
{
  return ellipse(win, x0, y0, rx, ry, PAK_PELLIPSE, "w_pellipse");
}


short w_dellipse(WWIN *win, short x0, short y0, short rx, short ry)
{
  return ellipse(win, x0, y0, rx, ry, PAK_DELLIPSE, "w_dellipse");
}


short w_dpellipse(WWIN *win, short x0, short y0, short rx, short ry)
{
  return ellipse(win, x0, y0, rx, ry, PAK_DPELLIPSE, "w_dpellipse");
}
