/*
 * lib/color.c, part of Wlib, part of W
 * (C) 94-04/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include "Wlib.h"
#include "proto.h"


/*
 *
 */

short w_allocColor (WWIN *win, uchar red, uchar green, uchar blue)
{
  char *cptr;
  ALLOCCOLP paket;
  short ret;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_allocColor(%p,%i,%i,%i) -> %s\n",
		win, red, green, blue, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(ALLOCCOLP);
  paket.type = PAK_ALLOCCOL;
  paket.handle = htons(win->handle);
  paket.red = htons(red);
  paket.green = htons(green);
  paket.blue = htons(blue);
  _send_paket((PAKET *)&paket);

  ret = ntohs(((SRETP *)_wait4paket(PAK_SRET))->ret);

  TRACEPRINT(("w_allocColor(%p,%i,%i,%i) -> %i\n",
	      win, red, green, blue, ret));
  TRACEEND();

  return ret;
}


short w_freeColor (WWIN *win, short color)
{
  char *cptr;
  FREECOLP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_freeColor(%p,%i) -> %s\n", win, color, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(FREECOLP);
  paket.type = PAK_FREECOL;
  paket.handle = htons(win->handle);
  paket.color = htons(color);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("w_freeColor(%p,%i) -> ok\n", win, color));
  TRACEEND();

  return 0;
}


short w_changeColor (WWIN *win, short color, uchar red, uchar green, uchar blue)
{
  char *cptr;
  CHANGECOLP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_changeColor(%p,%i,%i,%i,%i) -> %s\n",
		win, color, red, green, blue, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(CHANGECOLP);
  paket.type = PAK_CHANGECOL;
  paket.handle = htons(win->handle);
  paket.color = htons(color);
  paket.red = htons(red);
  paket.green = htons(green);
  paket.blue = htons(blue);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("w_changeColor(%p,%i,%i,%i,%i) -> ok\n",
	      win, color, red, green, blue));
  TRACEEND();

  return 0;
}


static inline short setColor(WWIN *win, short color, short type, char *fname)
{
  char *cptr;
  SETFGCOLP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("%s(%p,%i) -> %s\n", fname, win, color, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(SETFGCOLP);
  paket.type = type;
  paket.handle = htons(win->handle);
  paket.color = htons(color);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("%s(%p,%i) -> ok\n", fname, win, color));
  TRACEEND();

  return 0;
}


short w_setForegroundColor(WWIN *win, short color)
{
  return setColor(win, color, PAK_SETFGCOL, "w_setForegroundColor");
}


short w_setBackgroundColor(WWIN *win, short color)
{
  return setColor(win, color, PAK_SETBGCOL, "w_setBackgroundColor");
}


/*
 * possible future extensions
 */

short w_allocColorRange (WWIN *win, short colors, short start)
{
  TRACESTART();
  TRACEPRINT(("w_allocColorRange(%p,%i,%i) -> not yet implemented\n",
	      win, colors, start));
  TRACEEND();

  return -1;
}
