/*
 * lib/box.c, part of W
 * (C) 94-04/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * several box functions
 */

#include <stdio.h>
#include "Wlib.h"
#include "proto.h"


static inline short box(WWIN *win, short x0, short y0, short width,
			short height, short type, char *fname)
{
  char *cptr;
  BOXP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("%s(%p,%i,%i,%i,%i) -> %s\n",\
		fname, win, x0, y0, width, height, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(BOXP);
  paket.type = type;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.width = htons(width);
  paket.height = htons(height);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("%s(%p,%i,%i,%i,%i)\n",\
	      fname, win, x0, y0, width, height));

  TRACEEND();
  return 0;
}


short w_box(WWIN *win, short x0, short y0, short width, short height)
{
  return box(win, x0, y0, width, height, PAK_BOX, "w_box");
}


short w_pbox(WWIN *win, short x0, short y0, short width, short height)
{
  return box(win, x0, y0, width, height, PAK_PBOX, "w_pbox");
}


short w_dbox(WWIN *win, short x0, short y0, short width, short height)
{
  return box(win, x0, y0, width, height, PAK_DBOX, "w_dbox");
}


short w_dpbox(WWIN *win, short x0, short y0, short width, short height)
{
  return box(win, x0, y0, width, height, PAK_DPBOX, "w_dpbox");
}
