/*
 * lib/bitblk.c, part of W
 * (C) 94-03/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include "Wlib.h"
#include "proto.h"


short w_bitblk(WWIN *win, short x0, short y0, short width, short height,
	       short x1, short y1)
{
  char *cptr;
  BITBLKP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_bitblk(%p,%i,%i,%i,%i,%i,%i) -> %s\n",\
		win, x0, y0, width, height, x1, y1, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(BITBLKP);
  paket.type = PAK_BITBLK;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.width = htons(width);
  paket.height = htons(height);
  paket.x1 = htons(x1);
  paket.y1 = htons(y1);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("w_bitblk(%p,%i,%i,%i,%i,%i,%i)\n",\
	      win, x0, y0, width, height, x1, y1));

  TRACEEND();
  return 0;
}


short w_bitblk2(WWIN *swin, short x0, short y0, short width, short height,
		WWIN *dwin, short x1, short y1)
{
  char *cptr;
  BITBLKP paket;

  TRACESTART();

  if ((cptr = _check_window(swin))) {
    TRACEPRINT(("w_bitblk2(%p,%i,%i,%i,%i,%p,%i,%i) -> source: %s\n",\
		swin, x0, y0, width, height, dwin, x1, y1, cptr));
    TRACEEND();
    return -1;
  }

  if ((cptr = _check_window(dwin))) {
    TRACEPRINT(("w_bitblk2(%p,%i,%i,%i,%i,%p,%i,%i) -> dest: %s\n",\
		swin, x0, y0, width, height, dwin, x1, y1, cptr));
    TRACEEND();
    return -1;
  }

  paket.len = sizeof(BITBLKP);
  paket.type = PAK_BITBLK2;
  paket.handle = htons(swin->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.width = htons(width);
  paket.height = htons(height);
  paket.dhandle = htons(dwin->handle);
  paket.x1 = htons(x1);
  paket.y1 = htons(y1);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("w_bitblk2(%p,%i,%i,%i,%i,%p,%i,%i)\n",\
	      swin, x0, y0, width, height, dwin, x1, y1));
  TRACEEND();

  return 0;
}


short w_vscroll(WWIN *win, short x0, short y0,
		short width, short height, short y1)
{
  char *cptr;
  VSCROLLP paket;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("w_vscroll(%p,%i,%i,%i,%i,%i) -> %s\n",\
		win, x0, y0, width, height, y1, cptr));
    TRACEEND();
    return -1;
  }

  TRACEPRINT(("w_vscroll(%p,%i,%i,%i,%i,%i)\n",
	      win, x0, y0, width, height, y1));

  paket.len = sizeof(VSCROLLP);
  paket.type = PAK_VSCROLL;
  paket.handle = htons(win->handle);
  paket.x0 = htons(x0);
  paket.y0 = htons(y0);
  paket.width = htons(width);
  paket.height = htons(height);
  paket.y1 = htons(y1);
  _send_paket((PAKET *)&paket);

  TRACEEND();
  return 0;
}
