/*
 * lib/bezier.c, part of W
 * (C) 94-03/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 *
 * (w) by Eero Tamminen 10/96
 */

#include <stdio.h>
#include <stddef.h>
#include "Wlib.h"
#include "proto.h"


static inline short bezier(WWIN *win, short *points, short type, char *fname)
{
  char *cptr;
  BEZIERP paket;
  long i;

  TRACESTART();

  if ((cptr = _check_window(win))) {
    TRACEPRINT(("%s(%p,%p) -> %s\n", fname, win, points, cptr));
    TRACEEND();
    return -1;
  }

  for (i=0; i < 8; i++) {
    paket.points[i] = htons(*points);
    ++points;
  }
  paket.len = sizeof(BEZIERP);
  paket.type = type;
  paket.handle = htons(win->handle);
  _send_paket((PAKET *)&paket);

  TRACEPRINT(("%s(%p,%p)\n", fname, win, points));
  TRACEEND();
  return 0;
}


short w_bezier(WWIN *win, short *points)
{
  return bezier(win, points, PAK_BEZIER, "w_bezier");
}


short w_dbezier(WWIN *win, short *points)
{
  return bezier(win, points, PAK_DBEZIER, "w_dbezier");
}

