/*
 * Wlib.h - part of W
 * (C) 1994,95,96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#ifndef __W_WLIB_H
#define __W_WLIB_H

#include <sys/types.h>

#define _WMAJ 1
#define _WMIN 4
#define _WPL 0

#ifndef uchar
#define	uchar unsigned char
#endif
#ifndef ushort
#define	ushort unsigned short
#endif
#ifndef ulong
#define	ulong unsigned long
#endif

/* maaan, am I sick & tired to always have to define these... :( */
#undef ABS
#define	ABS(x) (((x)<0)?-(x):(x))
#undef MAX
#define MAX(a,b) ((a)>(b)?(a):(b))
#undef MIN
#define MIN(a,b) ((a)<(b)?(a):(b))

typedef struct {
  short vmaj, vmin, pl;		/* server version */
  short type;			/* graphics type */
  short width, height;
  short planes;			/* screen bit-depth */
  short flags;
  short fsize;			/* default font size */
  char *fname;			/* default font family */
} WSERVER;

/* some flags for the 'flags' field of WSERVER */
#define WSERVER_SHM 0x0001


/*
 * some bitmap types (used inside the server)
 */

#define BM_PACKEDCOLORMONO	0	/* bitplanes, monochrome */
#define BM_PACKEDMONO		1	/* 1 bitplane, monochrome */
#define BM_DIRECT8		2	/* 8-bit chunky (direct) colors */
#define BM_PACKEDCOLOR		3	/* bitplanes, colors settable */
#define BM_DIRECT24		4	/* 24-bit (rgb) image */

/*
 * the definition of all bitmaps. the fields are as following:
 *
 * 'width', 'height' - guess what
 * 'type' - type of bitmap (BM_PACKEDCOLORMONO, BM_PACKEDMONO,
 *          BM_PACKEDCOLOR, BM_DIRECT8 or BM_DIRECT24)
 * 'unitsize' - the number of bytes which form an access unit
 * 'upl' - how many of the above mentioned units make up one line
 * 'planes' - the number of bits (planes) used in any graphics mode
 * 'data' - again: guess what
 * 'colors' - number of colors with BM_PACKEDCOLOR and BM_DIRECT8
 * 'palette' - palette for the colors of above
 *
 * a normal ST/TT monochrome screen would have unitsize=4 (because 32 pixels
 * can be accessed at most) and planes=1, whereas a normal ST/TT color screen
 * would have unitsize=2 (because planes are 16 pixels wide) and planes>1. the
 * direct8 driver will use unitsize=1 and planes=8, but is aligned to 4 bytes.
 * ATM BM_DIRECT24 exists only on client side. Server doesn't support it.
 *
 * note: BM_PACKEDCOLOR type is allowed only for server side, you should
 * ignore it.
 */

typedef struct {
	uchar red;
	uchar green;
	uchar blue;
	/* here could be rest of the 32 color bits... */
} rgb_t;

typedef struct {
  short width;
  short height;
  short type;
  short unitsize;
  short upl;		/* units / line */
  short planes;		/* bits / pixel */
  void *data;
#ifndef __WSERVER	/* these are used only on client side */
  short colors;
  rgb_t *palette;	/* only for DIRECT8 and PACKEDCOLOR */
#endif
} BITMAP;

typedef struct {
  ulong ip_addr;
  long pakets, bytes;
  short totalWin, openWin;
} STATUS;

typedef struct _wfont {
  long magic;			/* MAGIC_F */
  short handle;

/* font type */
  short height;			/* font size */
  char *family;			/* font family name */
  ushort flags;			/* proportional, CHARSET etc. */
  ushort styles;		/* styles implemented in font */

/* font cell information */
  short baseline;		/* baseline offset for vertical aligning */
  short maxwidth;		/* width of the widest char */
  short top;			/* number of empty rows above chars */
  short bottom;			/* -"- below chars */
  short left;			/* number of empty colums left of chars */
  short right;			/* -"- right of chars */

  uchar widths[256];

  /* some elements to implement a linked list */
  struct _wfont *prev, *next;
  int used;
} WFONT;

typedef struct {
  long magic;   /* MAGIC_W */
  ushort handle;
  short width, height;
  short drawmode;
  ushort pattern;
  short textstyle;
  WFONT *font;

  /* some additional internal information */
  short type, x0, y0, reserved;

  /*
   * a place where the user can store something (eg. a pointer
   * to an additional structure associated with that window).
   */
  long user_val;
} WWIN;

/* root windows have type zeroed, subwindows use this */
#define WWIN_SUB	1

typedef struct {
  WWIN *win;
  short type, reserved[3];
  short x, y, w, h;
  long key;
} WEVENT;


/*
 *  various flags
 */

/* drawing modes */
#define	M_CLEAR		0		/* to background color */
#define	M_DRAW		1		/* to foreground color */
#define	M_INVERS	2		/* inverted, default */
#define M_TRANSP	3		/* 'holes' transparent */

/* grayscale patterns (0 - MAX_GRAYSCALES-1) */
#define MAX_GRAYSCALES	64

/* arbitrary patterns (MAX_GRAYSCALES - 0xfe) */
#define GRAY_PATTERN	0xfe		/* default */
#define W_PATTERN	0xfd		/* server background */

/* patterns for vertical and horizontal lines (0x00ff - 0xffff, rolled) */
#define LINE_DASH	0x00ff
#define LINE_DOT	0x3333
#define LINE_DASH_DOT	0x33ff		/* or 0x5fff */
#define LINES_1		0x0100
#define LINES_11	0x0101
#define LINES_111	0x1111
#define LINES_2		0x0300
#define LINES_22	0x0303
#define LINES_222	0x3333
#define LINES_4		0x0f00
#define LINES_44	0x0f0f
#define LINES_8		0x00ff

/* font styles */
#define	F_NORMAL	0x0000
#define	F_REVERSE	0x0001
#define	F_UNDERLINE	0x0002
#define F_ITALIC	0x0004
#define F_BOLD		0x0008
#define F_LIGHT		0x0010

/* something to mask legal styles */
#define	F_STYLEMASK	0x001f

/* special font flags */
#define F_LATIN1	0x0001		/* charset = ISO-latin1 (default) */
#define F_ASCII		0x0002		/* charset: 32-126 mapped to ASCII */
#define F_SYMBOL	0x0004		/* charset: any */
#define F_PROP		0x0008		/* proportional font */

/* W window events */
#define	W_MOVE		0x0001
#define	W_TOP		0x0002
#define	W_TITLE		0x0004
#define	EV_KEYS		0x0008
#define	EV_MOUSE	0x0010
#define	W_NOBORDER	0x0020
#define	W_NOMOUSE	0x0040
#define EV_ACTIVE	0x0080
#define W_CLOSE		0x0100
#define W_ICON		0x0200
#define	W_CONTAINER	0x0400
#define W_RESIZE	0x0800

#define	W_FLAGMASK	0x0fff

#define	BUTTON_LEFT	4
#define	BUTTON_MID	2
#define	BUTTON_RIGHT	1

#define	EVENT_KEY	0x0001
#define	EVENT_MMOVE	0x0002
#define	EVENT_MPRESS	0x0003
#define	EVENT_MRELEASE	0x0004
#define	EVENT_BUTTON	0x0005
#define	EVENT_GADGET	0x0006
#define	EVENT_SAVEON	0x0007
#define	EVENT_SAVEOFF	0x0008
#define EVENT_ACTIVE	0x0009
#define EVENT_INACTIVE	0x000a
#define EVENT_RESIZE	0x000b

#define	GADGET_EXIT	0x0001
#define	GADGET_CLOSE	0x0002
#define GADGET_ICON	0x0003
#define GADGET_SIZE	0x0004

#define	MAGIC_W	0x15263748
#define	MAGIC_F	0x15263749

/* special flag for w_open() */
#define UNDEF -32768


/*
 *
 */

extern WWIN *WROOT;
extern WWIN *WSCREEN;   /* not yet implemented */


#define W_SEL_TEXT	"text"		/* '\t' || '\n' || >= 32 */
#define W_SEL_VALUE	"value"		/* '0' - '9' */
#define W_SEL_DATA	"data"		/* 0-255 */
#define W_SEL_FILE	"file"		/* file path / name */
#define W_SET_TYPE	"type"		/* clip type for type requests */
#define W_SELTYPE_MAX	15		/* max. clip type id lenght */

typedef struct {
  char  type[W_SELTYPE_MAX+1];
  char *data;
  long len;
} w_selection_t;

typedef int w_clipboard_t;	/* ATM file descriptor */

/*
 * some functions
 */

extern w_clipboard_t  w_selopen (char *type);
extern w_clipboard_t  w_selappend (w_clipboard_t, char *data, long len);
extern void           w_selclose (w_clipboard_t);
extern w_selection_t* w_getselection (char *type);
extern int 	      w_putselection (char *type, char *data, long len);
extern void	      w_freeselection (w_selection_t *);

extern WSERVER	*w_init(void);
extern void	w_exit(void);
extern WWIN	*w_create(short width, short height, short flags);
extern WWIN	*w_createChild(WWIN *parent, short width, short height, short flags);
extern short	w_open(WWIN *win, short x0, short y0);
extern short	w_move(WWIN *win, short x0, short y0);
extern short	w_resize(WWIN *win, short width, short height);
extern short	w_close(WWIN *win);
extern short	w_delete(WWIN *win);

extern WFONT	*w_loadfont(char *family, short size, ushort stylemask);
extern short	w_unloadfont(WFONT *font);
extern int	w_strlen(WFONT *font, char *s);
extern char	*w_fonttype(char *filename, short *size, short *styles);

extern WEVENT	*w_querybuttonevent(fd_set *rdp, fd_set *wdp, fd_set *xdp, long timeout);
extern WWIN	*w_createButton(WWIN *parent, short x0, short y0, short width, short height);
extern short	w_showButton(WWIN *button);
extern short	w_hideButton(WWIN *button);

extern WEVENT	*w_queryevent(fd_set *rdp, fd_set *wdp, fd_set *xdp, long timeout);

extern short	w_querywinsize(WWIN *win, short effective, short *width, short *height);
extern short	w_settitle(WWIN *win, char *s);
extern short	w_setmode(WWIN *win, short mode);
extern short	w_plot(WWIN *win, short x0, short y0);
extern short	w_dplot(WWIN *win, short x0, short y0);
extern short	w_test(WWIN *win, short x0, short y0);
extern short	w_line(WWIN *win, short x0, short y0, short xe, short ye);
extern short	w_dline(WWIN *win, short x0, short y0, short xe, short ye);
extern short	w_hline(WWIN *win, short x0, short y0, short xe);
extern short	w_dhline(WWIN *win, short x0, short y0, short xe);
extern short	w_vline(WWIN *win, short x0, short y0, short ye);
extern short	w_dvline(WWIN *win, short x0, short y0, short ye);
extern short	w_box(WWIN *win, short x0, short y0, short width, short height);
extern short	w_dbox(WWIN *win, short x0, short y0, short width, short height);
extern short	w_pbox(WWIN *win, short x0, short y0, short width, short height);
extern short	w_dpbox(WWIN *win, short x0, short y0, short width, short height);
extern short	w_bitblk(WWIN *win, short x0, short y0, short width, short height, short x1, short y1);
extern short	w_bitblk2(WWIN *swin, short x0, short y0, short width, short height, WWIN *dwin, short x1, short y1);
extern short	w_vscroll(WWIN *win, short x0, short y0, short width, short height, short y1);
extern WFONT	*w_setfont(WWIN *win, WFONT *font);
extern short	w_settextstyle(WWIN *win, short flags);
extern short	w_printchar(WWIN *win, short x0, short y0, short c);
extern short	w_printstring(WWIN *win, short x0, short y0, char *s);
extern short	w_centerPrints(WWIN *win, WFONT *font, char *s);
extern short	w_querymousepos(WWIN *win, short *x0, short *y0);
extern short	w_querywindowpos(WWIN *win, short effective, short *x0, short *y0);
extern BITMAP	*w_getblock(WWIN *win, short x0, short y0, short width, short height);
extern short	w_putblock(BITMAP *bm, WWIN *win, short x1, short y1);
extern short	w_circle(WWIN *win, short x0, short y0, short r);
extern short	w_dcircle(WWIN *win, short x0, short y0, short r);
extern short	w_pcircle(WWIN *win, short x0, short y0, short r);
extern short	w_dpcircle(WWIN *win, short x0, short y0, short r);
extern short	w_ellipse(WWIN *win, short x0, short y0, short rx, short ry);
extern short	w_dellipse(WWIN *win, short x0, short y0, short rx, short ry);
extern short	w_pellipse(WWIN *win, short x0, short y0, short rx, short ry);
extern short	w_dpellipse(WWIN *win, short x0, short y0, short rx, short ry);
extern short	w_querystatus(STATUS *st, short index);
extern ushort	w_setpattern(WWIN *win, ushort pattern);
extern short	w_poly(WWIN *win, short numpoints, short *points);
extern short	w_dpoly(WWIN *win, short numpoints, short *points);
extern short	w_ppoly(WWIN *win, short numpoints, short *points);
extern short	w_dppoly(WWIN *win, short numpoints, short *points);
extern short	w_bezier(WWIN *win, short *controls);
extern short	w_dbezier(WWIN *win, short *controls);
extern short	w_setsaver(short seconds);
extern short	w_null(void);
extern void	w_flush(void);
extern short	w_beep(void);
extern void	w_trace(short flag);
extern void	scan_geometry(char *geometry, short *col, short *lin, short *xp, short *yp);
extern void	limit2screen(WWIN *win, short *xp, short *yp);

extern BITMAP	*w_readimg(char *fname, short *width, short *height);
extern BITMAP	*w_xpm2bm(char **xpm);
extern BITMAP	*w_readpbm(char *path);
extern short	w_writepbm(char *path, BITMAP *bm);

extern BITMAP	*w_allocbm(short width, short height, short type, short colors);
extern BITMAP	*w_convertBitmap(BITMAP *src, short dst_type, short dst_colors);
extern uchar	*(*w_convertFunction(BITMAP *src, BITMAP *dst))();
extern void	w_ditherOptions(uchar *graymap, int expand);
extern BITMAP	*w_copybm(BITMAP *bm);
extern void	w_freebm(BITMAP *bm);

extern short	w_allocColor(WWIN *win, uchar red, uchar green, uchar blue);
extern short	w_freeColor(WWIN *win, short color);
extern short	w_changeColor(WWIN *win, short color, uchar red, uchar green, uchar blue);
extern short	w_setForegroundColor(WWIN *win, short color);
extern short	w_setBackgroundColor(WWIN *win, short color);
extern short	w_allocColorRange(WWIN *win, short colors, short start);

#endif /* __W_WLIB_H */
