/* Jewel bitmaps (8 * 16x16 pieces = 128x16 pixels)
 * 6 pieces, 'jewel' and border blocks.
 *
 * Note that W needs image bitmap to be long aligned.
 *
 * WJewel (w) 1996 by Eero Tamminen, t150315@cc.tut.fi
 */

#include "jewel.h"

#define BLK_SIZE	16

static unsigned char bitmaps[BLOCKS * BLK_SIZE / 8 * BLK_SIZE] =
{
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01,
  0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x01,
  0xbf, 0xfb, 0xbf, 0xfb, 0xbf, 0xfb, 0xbf, 0xfb,
  0xbf, 0xfb, 0xbf, 0xfb, 0x81, 0x03, 0xa0, 0x03,
  0xb5, 0x53, 0xbf, 0xfb, 0xa0, 0x03, 0xa6, 0x33,
  0xbc, 0x73, 0xbf, 0xf3, 0x82, 0x83, 0x90, 0x07,
  0xaa, 0xab, 0xbf, 0xfb, 0xa0, 0x03, 0xac, 0x63,
  0xbc, 0x73, 0xb0, 0x03, 0x85, 0x43, 0x88, 0x0f,
  0xb5, 0x53, 0xbf, 0xfb, 0xa0, 0x03, 0xb8, 0xc3,
  0xbc, 0x73, 0xb0, 0x13, 0x89, 0xa3, 0x84, 0x1f,
  0xaa, 0xab, 0xbf, 0xfb, 0xa0, 0x03, 0xb1, 0x8b,
  0xa3, 0x83, 0xb3, 0xb3, 0x91, 0x53, 0x82, 0x3f,
  0xb5, 0x53, 0xbf, 0xfb, 0xa0, 0x03, 0xa3, 0x1b,
  0xa3, 0x83, 0xb2, 0x33, 0xaf, 0xfb, 0x81, 0x7f,
  0xaa, 0xab, 0xbf, 0xfb, 0xa0, 0x03, 0xa6, 0x33,
  0xa3, 0x83, 0xb2, 0x33, 0x95, 0xf3, 0x80, 0x7f,
  0xb5, 0x53, 0xbf, 0xfb, 0xa0, 0x03, 0xac, 0x63,
  0xbc, 0x73, 0xb0, 0x33, 0x8b, 0xe3, 0x81, 0xbf,
  0xaa, 0xab, 0xbf, 0xfb, 0xa0, 0x03, 0xb8, 0xc3,
  0xbc, 0x73, 0xb3, 0xf3, 0x85, 0xc3, 0x83, 0xdf,
  0xb5, 0x53, 0xbf, 0xfb, 0xa0, 0x03, 0xb1, 0x8b,
  0xbc, 0x73, 0xb7, 0xf3, 0x83, 0x83, 0x87, 0xef,
  0xaa, 0xab, 0xbf, 0xfb, 0xa0, 0x03, 0xa3, 0x1b,
  0xa0, 0x03, 0xa0, 0x03, 0x81, 0x03, 0x8f, 0xf7,
  0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03,
  0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x9f, 0xfb,
  0xbf, 0xff, 0xbf, 0xff, 0xbf, 0xff, 0xbf, 0xff,
  0xbf, 0xff, 0xbf, 0xff, 0xbf, 0xff, 0xbf, 0xfd,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};


Blocks SmallBlocks =
{
  BLK_SIZE,
  BLK_SIZE,
  bitmaps
};

