#!/bin/sh

# before use:  Set 'fontdir' in the script below to point to
# W font directory. Copy the fonts to be modified onto some other
# directory (or shell redirection will truncate them to zero)!!!
# Run the script (source newfonts.sh).

function newfonts()
{
	# W default: fontdir=/usr/local/lib/wfonts
	fontdir=/home/eero/work/w1r4pl0/fonts
	verbose=false

	for i in $*
	do
		case $i in
			-v)		verbose=true; continue;;
			*[0-9]bi.*)	options="-s bi";;
			*[0-9]i.*)	options="-s i";;
			*[0-9]b.*)	options="-s b";;
			*)		options="";;
		esac
		name=${i##*/}
		if [ $verbose = true ]
		then
			echo "converting $i to $fontdir/$name..."
			fontedit $i -v 1 -u $options > $fontdir/$name
		else
			fontedit $i -u $options > $fontdir/$name
		fi
	done
	return 0
}

export newfonts

# usage message
cat << EOF
usage: newfonts [-v] <fonts>

will show the new font attributes (if '-v' used) and then write the
font into font directory 'fontdir' defined in the script.
EOF
