/*
 * A replacement for 'xmountains' X_graphics.c file allowing one to
 * run 'xmountains' fractal mountain generator under W.
 *
 * (w) 1997 by Eero Tamminen
 */

#include <stdio.h>
#include <stdlib.h>
#include <Wlib.h>
#include "paint.h"

/* globals used by xmountains.c */

char *display = NULL;       /* name of display to open, NULL for default */
char *geom = NULL;          /* geometry of window, NULL for default */
int quit_xmount = 0;

/* local globals */
static WWIN *Win;
static int *Gray;	/* color lookup table */
static int x0, y0, y1;
static int Oldcol = -1;


void zap_events(int snooze)
{
	WEVENT *ev;
	if (quit_xmount || (ev = w_queryevent(NULL, NULL, NULL, snooze))) {
		w_exit();
		exit(0);
	}
}


void finish_graphics(void)
{
	w_exit();
}


void init_graphics(int use_root, int background, int clear,
		   int *width, int *height, int ncols,
		   ushort *red, ushort *green, ushort *blue)
{
	short wd, ht, wx = UNDEF, wy = UNDEF;
	static WSERVER *server = NULL;

	if (!server && !(server = w_init())) {
		fprintf(stderr, "Unable to connect W server\n");
		exit(-1);
	}

	if (use_root) {
		Win = WROOT;
		wd = server->width;
		ht = server->height;
	} else {
		if (geom) {
			scan_geometry(geom, &wd, &ht, &wx, &wy);
		} else {
			wd = server->width - 8;
			ht = server->height - 20;
		}
	}
	*width = wd;
	*height = ht;

	if (!Win && !(Win = w_create(wd, ht, W_TITLE|W_MOVE|EV_MOUSE))) {
		fprintf(stderr, "unable to create a W window\n");
		w_exit();
		exit(-1);
	}
	w_setmode(Win, M_DRAW);
	w_pbox(Win, 0, 0, wd, ht);

	if(w_open(Win, wx, wy) < 0) {
		fprintf(stderr, "unable to open a W window\n");
		w_exit();
		exit(-1);
	}

	if (!Gray) {
		long value;
		int idx;

		if (!(Gray = malloc(sizeof(int) * ncols))) {
			fprintf(stderr, "palette table alloc failed\n");
			w_exit();
			exit(-1);
		}
		idx = ncols;
		while (--idx >= 0) {
			value = red[idx] + green[idx] + blue[idx];
			Gray[idx] = MAX_GRAYSCALES * value / (3 * ((1<<16)-1));
		}
	}
}


void scroll_screen(int dist)
{
	int reverse = 0;
	if (dist < 0) {
		reverse = 1;
		dist = -dist;
	}
	if (dist > Win->width) {
		dist = Win->width;
	}
	/* copy data and blank new area */
	if (reverse) {
		w_bitblk(Win, 0, 0, Win->width - dist, Win->height, dist, 0);
		w_pbox(Win, 0, 0, dist, Win->height);
	} else {
		w_bitblk(Win, dist, 0, Win->width - dist, Win->height, 0, 0);
		w_pbox(Win, Win->width - dist, 0, dist, Win->height);
	}
}


void update(void)
{
	if (y0 != y1) {
		w_dvline(Win, x0, y1, y0);
	} else {
		w_dplot(Win, x0, y0);
	}
}


void plot_pixel(int x, int y, short value)
{
	value = Gray[value];

	if (value == Oldcol && x == x0) {
		y1 = y;
	} else {
		if (Oldcol >= 0) {
			update();
		}
		w_setpattern(Win, value);
		Oldcol = value;
		x0 = x;
		y0 = y;
		y1 = y;
	}
}


void flush_region(int x, int y, int w, int h)
{
	/* flush outstanding plots */
	update();
	Oldcol = -1;
	w_flush();
}

