/*
 * programs/wlines.c, part of W
 * (C) 94-02/96 by Torsten Scherer (TeSche)
 * itschere@techfak.uni-bielefeld.de
 */

#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <Wlib.h>

#define	WIDTH	160
#define	HEIGHT	100


WWIN *win;


void terminate()
{
  /* let the server take notice that we've died, calling any Wlib function
   * from within a signal handler is NOT allowed.
   */
  exit(0);
}


/*
 * guess what...
 */

void main(long argc, char *argv[])
{
  short x, y;
  WEVENT *ev;

  signal(SIGTTOU, SIG_IGN);

  if (!w_init()) {
    fprintf(stderr, "error: wlines can't open wserver pipe\n");
    exit(-1);
  }

  if (!(win = w_create(WIDTH, HEIGHT, W_MOVE))) {
    fprintf(stderr, "error: wlines can't create window\n");
    exit(-1);
  }

  if ((w_open(win, UNDEF, UNDEF)) < 0) {
    fprintf(stderr, "error: wlines can't open window\n");
    exit(-1);
  }

  signal(SIGHUP, terminate);
  signal(SIGINT, terminate);
  signal(SIGQUIT, terminate);
  signal(SIGABRT, terminate);
  signal(SIGTERM, terminate);

  while(42) {
    for (x=0; x<WIDTH; x++) {
      w_line(win, x, 0, WIDTH-x-1, HEIGHT-1);
    }
    for (y=0; y<HEIGHT; y++) {
      w_line(win, 0, y, WIDTH-1, HEIGHT-y-1);
    }
    if ((ev = w_queryevent(NULL, NULL, NULL, 0))) {
      if ((ev->type == EVENT_GADGET) && (ev->key == GADGET_EXIT)) {
	w_delete(win);
	exit(-1);
      }
    }
  }
}
