
#include <stdio.h>
#include <math.h>
#include <Wlib.h>

#define WD	200	/* window width */
#define HT	200	/* window height */
#define COUNT	20	/* line draw count */

static int lenght = 40;
static int branches = 3;
static int  wide = 180;
static WWIN *win;

void draw_cracks(int ox, int oy, double angle, int count)
{
	double len;
	int nx, ny;

	/* later on we divide with count, so has to be > 0 */
	while (--count > 0) {

		len = rand() % lenght;
		angle += (rand() % wide - wide / 2) * (M_PI / 180.0);
		nx = ox + cos(angle) * len;
		ny = oy + sin(angle) * len;
		w_line(win, ox, oy, nx, ny);

		/* wrap around? (tileable) */
		if (nx < 0 || ny < 0 || nx >= WD || ny >= HT) {
			if (nx < 0) {
				ox += WD;
				nx += WD;
			}
			if (ny < 0) {
				oy += HT;
				ny += HT;
			}
			if (nx >= WD) {
				ox -= WD;
				nx -= WD;
			}
			if (ny >= HT) {
				oy -= HT;
				ny -= HT;
			}
			w_line(win, ox, oy, nx, ny);
		}

		ox = nx;
		oy = ny;
		if (rand() % branches == 0) {
			int c = count + rand() % count/2 - count/4;
			draw_cracks(ox, oy, angle, c);
		}
	}
}

int clear(WWIN *win)
{
	w_setmode(win, M_DRAW);
	w_pbox(win, 0, 0, WD, HT);
	w_setmode(win, M_CLEAR);
}

void help(void)
{
	printf("\nW cracks: draws 'cracks' or 'lightning'\n\n");
	printf("usage: wcracks [-a angle] [-b branch%] [-c count] [-l lenght]\n");
	printf("default: wcracks -a %d -b %d -c %d -l %d\n", wide, branches, COUNT, lenght);
}

int main(int argc, char *argv[])
{
	int idx, count = COUNT;
	double len, angle;
	WEVENT *ev;

	idx = 0;
	while (++idx < argc) {
		if (argv[idx][0] == '-' && !argv[idx][2] && idx+1 < argc) {
			switch(argv[idx++][1]) {
				case 'a':
					wide = atoi(argv[idx]);
					break;
				case 'b':
					branches = atoi(argv[idx]);
					break;
				case 'c':
					count = atoi(argv[idx]);
					break;
				case 'l':
					lenght = atoi(argv[idx]);
					break;
				default:
					help();
					return -1;
			}
		} else {
			help();
			return -1;
		}
	}

	w_init();
	win = w_create(WD, HT, W_MOVE | W_TITLE | EV_KEYS | EV_MOUSE);
	w_open(win, UNDEF, UNDEF);

	srand(clock());
	branches = 100.0 / branches;
	for (;;) {
		clear(win);
		draw_cracks(WD/2, HT/2, 0, count);
		ev = w_queryevent(NULL, NULL, NULL, -1);
		if (ev && ev->type == EVENT_GADGET) {
			break;
		}
	}
	w_exit();
	return;
}
